/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.interpro;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.interpro.InterPro;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.interpro.InterProId;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.interpro.InterProShortName;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class InterProImpl
extends DatabaseCrossReferenceImpl
implements InterPro,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.INTERPRO;
    private long id = 0L;
    private InterProId interProId = DefaultXRefFactory.getInstance().buildInterProId("");
    private InterProShortName interProShortName = DefaultXRefFactory.getInstance().buildInterProShortName("");

    public InterProImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getInterProId().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public InterProImpl(InterProImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasInterProId()) {
            this.setInterProId(toCopy.getInterProId());
        }
        if (toCopy.hasInterProShortName()) {
            this.setInterProShortName(toCopy.getInterProShortName());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof InterProImpl)) {
            return false;
        }
        InterProImpl myClass = (InterProImpl)o;
        if (!this.interProId.equals(myClass.getInterProId())) {
            return false;
        }
        return this.interProShortName.equals(myClass.getInterProShortName());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.interProId != null ? this.interProId.hashCode() : 0);
        result = 29 * result + (this.interProShortName != null ? this.interProShortName.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.interProId + ":" + this.interProShortName + ";";
    }

    @Override
    public InterProId getInterProId() {
        return this.interProId;
    }

    @Override
    public void setInterProId(InterProId interProId) {
        if (interProId == null) {
            throw new IllegalArgumentException();
        }
        this.interProId = interProId;
    }

    @Override
    public boolean hasInterProId() {
        return !this.interProId.getValue().equals("");
    }

    @Override
    public InterProShortName getInterProShortName() {
        return this.interProShortName;
    }

    @Override
    public void setInterProShortName(InterProShortName interProShortName) {
        if (interProShortName == null) {
            throw new IllegalArgumentException();
        }
        this.interProShortName = interProShortName;
    }

    @Override
    public boolean hasInterProShortName() {
        return !this.interProShortName.getValue().equals("");
    }
}

