/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.intact;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.intact.IntAct;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.intact.IntActAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.intact.IntActDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class IntActImpl
extends DatabaseCrossReferenceImpl
implements IntAct,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.INTACT;
    private long id = 0L;
    private IntActAccessionNumber intActAccessionNumber = DefaultXRefFactory.getInstance().buildIntActAccessionNumber("");
    private IntActDescription intActDescription = DefaultXRefFactory.getInstance().buildIntActDescription("");

    public IntActImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getIntActAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public IntActImpl(IntActImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasIntActAccessionNumber()) {
            this.setIntActAccessionNumber(toCopy.getIntActAccessionNumber());
        }
        if (toCopy.hasIntActDescription()) {
            this.setIntActDescription(toCopy.getIntActDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntActImpl)) {
            return false;
        }
        IntActImpl myClass = (IntActImpl)o;
        if (!this.intActAccessionNumber.equals(myClass.getIntActAccessionNumber())) {
            return false;
        }
        return this.intActDescription.equals(myClass.getIntActDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.intActAccessionNumber != null ? this.intActAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.intActDescription != null ? this.intActDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.intActAccessionNumber + ":" + this.intActDescription + ";";
    }

    @Override
    public IntActAccessionNumber getIntActAccessionNumber() {
        return this.intActAccessionNumber;
    }

    @Override
    public void setIntActAccessionNumber(IntActAccessionNumber intActAccessionNumber) {
        if (intActAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.intActAccessionNumber = intActAccessionNumber;
    }

    @Override
    public boolean hasIntActAccessionNumber() {
        return !this.intActAccessionNumber.getValue().equals("");
    }

    @Override
    public IntActDescription getIntActDescription() {
        return this.intActDescription;
    }

    @Override
    public void setIntActDescription(IntActDescription intActDescription) {
        if (intActDescription == null) {
            throw new IllegalArgumentException();
        }
        this.intActDescription = intActDescription;
    }

    @Override
    public boolean hasIntActDescription() {
        return !this.intActDescription.getValue().equals("");
    }
}

