/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.inparanoid;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.inparanoid.InParanoid;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.inparanoid.InParanoidAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.inparanoid.InParanoidDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class InParanoidImpl
extends DatabaseCrossReferenceImpl
implements InParanoid,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.INPARANOID;
    private long id = 0L;
    private InParanoidAccessionNumber inParanoidAccessionNumber = DefaultXRefFactory.getInstance().buildInParanoidAccessionNumber("");
    private InParanoidDescription inParanoidDescription = DefaultXRefFactory.getInstance().buildInParanoidDescription("");

    public InParanoidImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getInParanoidAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public InParanoidImpl(InParanoidImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasInParanoidAccessionNumber()) {
            this.setInParanoidAccessionNumber(toCopy.getInParanoidAccessionNumber());
        }
        if (toCopy.hasInParanoidDescription()) {
            this.setInParanoidDescription(toCopy.getInParanoidDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof InParanoidImpl)) {
            return false;
        }
        InParanoidImpl myClass = (InParanoidImpl)o;
        if (!this.inParanoidAccessionNumber.equals(myClass.getInParanoidAccessionNumber())) {
            return false;
        }
        return this.inParanoidDescription.equals(myClass.getInParanoidDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.inParanoidAccessionNumber != null ? this.inParanoidAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.inParanoidDescription != null ? this.inParanoidDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.inParanoidAccessionNumber + ":" + this.inParanoidDescription + ";";
    }

    @Override
    public InParanoidAccessionNumber getInParanoidAccessionNumber() {
        return this.inParanoidAccessionNumber;
    }

    @Override
    public void setInParanoidAccessionNumber(InParanoidAccessionNumber inParanoidAccessionNumber) {
        if (inParanoidAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.inParanoidAccessionNumber = inParanoidAccessionNumber;
    }

    @Override
    public boolean hasInParanoidAccessionNumber() {
        return !this.inParanoidAccessionNumber.getValue().equals("");
    }

    @Override
    public InParanoidDescription getInParanoidDescription() {
        return this.inParanoidDescription;
    }

    @Override
    public void setInParanoidDescription(InParanoidDescription inParanoidDescription) {
        if (inParanoidDescription == null) {
            throw new IllegalArgumentException();
        }
        this.inParanoidDescription = inParanoidDescription;
    }

    @Override
    public boolean hasInParanoidDescription() {
        return !this.inParanoidDescription.getValue().equals("");
    }
}

