/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.hssp;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hssp.Hssp;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hssp.HsspAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hssp.HsspDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class HsspImpl
extends DatabaseCrossReferenceImpl
implements Hssp,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.HSSP;
    private long id = 0L;
    private HsspAccessionNumber hsspAccessionNumber = DefaultXRefFactory.getInstance().buildHsspAccessionNumber("");
    private HsspDescription hsspDescription = DefaultXRefFactory.getInstance().buildHsspDescription("");

    public HsspImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getHsspAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public HsspImpl(HsspImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasHsspAccessionNumber()) {
            this.setHsspAccessionNumber(toCopy.getHsspAccessionNumber());
        }
        if (toCopy.hasHsspDescription()) {
            this.setHsspDescription(toCopy.getHsspDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof HsspImpl)) {
            return false;
        }
        HsspImpl myClass = (HsspImpl)o;
        if (!this.hsspAccessionNumber.equals(myClass.getHsspAccessionNumber())) {
            return false;
        }
        return this.hsspDescription.equals(myClass.getHsspDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.hsspAccessionNumber != null ? this.hsspAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.hsspDescription != null ? this.hsspDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.hsspAccessionNumber + ":" + this.hsspDescription + ";";
    }

    @Override
    public HsspAccessionNumber getHsspAccessionNumber() {
        return this.hsspAccessionNumber;
    }

    @Override
    public void setHsspAccessionNumber(HsspAccessionNumber hsspAccessionNumber) {
        if (hsspAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.hsspAccessionNumber = hsspAccessionNumber;
    }

    @Override
    public boolean hasHsspAccessionNumber() {
        return !this.hsspAccessionNumber.getValue().equals("");
    }

    @Override
    public HsspDescription getHsspDescription() {
        return this.hsspDescription;
    }

    @Override
    public void setHsspDescription(HsspDescription hsspDescription) {
        if (hsspDescription == null) {
            throw new IllegalArgumentException();
        }
        this.hsspDescription = hsspDescription;
    }

    @Override
    public boolean hasHsspDescription() {
        return !this.hsspDescription.getValue().equals("");
    }
}

