/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.hsc2dpage;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hsc2dpage.Hsc2dpage;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hsc2dpage.Hsc2dpageAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hsc2dpage.Hsc2dpageDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class Hsc2dpageImpl
extends DatabaseCrossReferenceImpl
implements Hsc2dpage,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.HSC2DPAGE;
    private long id = 0L;
    private Hsc2dpageAccessionNumber hsc2dpageAccessionNumber = DefaultXRefFactory.getInstance().buildHsc2dpageAccessionNumber("");
    private Hsc2dpageDescription hsc2dpageDescription = DefaultXRefFactory.getInstance().buildHsc2dpageDescription("");

    public Hsc2dpageImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getHsc2dpageAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public Hsc2dpageImpl(Hsc2dpageImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasHsc2dpageAccessionNumber()) {
            this.setHsc2dpageAccessionNumber(toCopy.getHsc2dpageAccessionNumber());
        }
        if (toCopy.hasHsc2dpageDescription()) {
            this.setHsc2dpageDescription(toCopy.getHsc2dpageDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Hsc2dpageImpl)) {
            return false;
        }
        Hsc2dpageImpl myClass = (Hsc2dpageImpl)o;
        if (!this.hsc2dpageAccessionNumber.equals(myClass.getHsc2dpageAccessionNumber())) {
            return false;
        }
        return this.hsc2dpageDescription.equals(myClass.getHsc2dpageDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.hsc2dpageAccessionNumber != null ? this.hsc2dpageAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.hsc2dpageDescription != null ? this.hsc2dpageDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.hsc2dpageAccessionNumber + ":" + this.hsc2dpageDescription + ";";
    }

    @Override
    public Hsc2dpageAccessionNumber getHsc2dpageAccessionNumber() {
        return this.hsc2dpageAccessionNumber;
    }

    @Override
    public void setHsc2dpageAccessionNumber(Hsc2dpageAccessionNumber hsc2dpageAccessionNumber) {
        if (hsc2dpageAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.hsc2dpageAccessionNumber = hsc2dpageAccessionNumber;
    }

    @Override
    public boolean hasHsc2dpageAccessionNumber() {
        return !this.hsc2dpageAccessionNumber.getValue().equals("");
    }

    @Override
    public Hsc2dpageDescription getHsc2dpageDescription() {
        return this.hsc2dpageDescription;
    }

    @Override
    public void setHsc2dpageDescription(Hsc2dpageDescription hsc2dpageDescription) {
        if (hsc2dpageDescription == null) {
            throw new IllegalArgumentException();
        }
        this.hsc2dpageDescription = hsc2dpageDescription;
    }

    @Override
    public boolean hasHsc2dpageDescription() {
        return !this.hsc2dpageDescription.getValue().equals("");
    }
}

