/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.hpa;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hpa.HPA;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hpa.HPAAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hpa.HPADescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class HPAImpl
extends DatabaseCrossReferenceImpl
implements HPA,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.HPA;
    private long id = 0L;
    private HPAAccessionNumber hPAAccessionNumber = DefaultXRefFactory.getInstance().buildHPAAccessionNumber("");
    private HPADescription hPADescription = DefaultXRefFactory.getInstance().buildHPADescription("");

    public HPAImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getHPAAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public HPAImpl(HPAImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasHPAAccessionNumber()) {
            this.setHPAAccessionNumber(toCopy.getHPAAccessionNumber());
        }
        if (toCopy.hasHPADescription()) {
            this.setHPADescription(toCopy.getHPADescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof HPAImpl)) {
            return false;
        }
        HPAImpl myClass = (HPAImpl)o;
        if (!this.hPAAccessionNumber.equals(myClass.getHPAAccessionNumber())) {
            return false;
        }
        return this.hPADescription.equals(myClass.getHPADescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.hPAAccessionNumber != null ? this.hPAAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.hPADescription != null ? this.hPADescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.hPAAccessionNumber + ":" + this.hPADescription + ";";
    }

    @Override
    public HPAAccessionNumber getHPAAccessionNumber() {
        return this.hPAAccessionNumber;
    }

    @Override
    public void setHPAAccessionNumber(HPAAccessionNumber hPAAccessionNumber) {
        if (hPAAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.hPAAccessionNumber = hPAAccessionNumber;
    }

    @Override
    public boolean hasHPAAccessionNumber() {
        return !this.hPAAccessionNumber.getValue().equals("");
    }

    @Override
    public HPADescription getHPADescription() {
        return this.hPADescription;
    }

    @Override
    public void setHPADescription(HPADescription hPADescription) {
        if (hPADescription == null) {
            throw new IllegalArgumentException();
        }
        this.hPADescription = hPADescription;
    }

    @Override
    public boolean hasHPADescription() {
        return !this.hPADescription.getValue().equals("");
    }
}

