/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.hovergen;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hovergen.Hovergen;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hovergen.HovergenAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hovergen.HovergenDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class HovergenImpl
extends DatabaseCrossReferenceImpl
implements Hovergen,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.HOVERGEN;
    private long id = 0L;
    private HovergenAccessionNumber hovergenAccessionNumber = DefaultXRefFactory.getInstance().buildHovergenAccessionNumber("");
    private HovergenDescription hovergenDescription = DefaultXRefFactory.getInstance().buildHovergenDescription("");

    public HovergenImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getHovergenAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public HovergenImpl(HovergenImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasHovergenAccessionNumber()) {
            this.setHovergenAccessionNumber(toCopy.getHovergenAccessionNumber());
        }
        if (toCopy.hasHovergenDescription()) {
            this.setHovergenDescription(toCopy.getHovergenDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof HovergenImpl)) {
            return false;
        }
        HovergenImpl myClass = (HovergenImpl)o;
        if (!this.hovergenAccessionNumber.equals(myClass.getHovergenAccessionNumber())) {
            return false;
        }
        return this.hovergenDescription.equals(myClass.getHovergenDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.hovergenAccessionNumber != null ? this.hovergenAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.hovergenDescription != null ? this.hovergenDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.hovergenAccessionNumber + ":" + this.hovergenDescription + ";";
    }

    @Override
    public HovergenAccessionNumber getHovergenAccessionNumber() {
        return this.hovergenAccessionNumber;
    }

    @Override
    public void setHovergenAccessionNumber(HovergenAccessionNumber hovergenAccessionNumber) {
        if (hovergenAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.hovergenAccessionNumber = hovergenAccessionNumber;
    }

    @Override
    public boolean hasHovergenAccessionNumber() {
        return !this.hovergenAccessionNumber.getValue().equals("");
    }

    @Override
    public HovergenDescription getHovergenDescription() {
        return this.hovergenDescription;
    }

    @Override
    public void setHovergenDescription(HovergenDescription hovergenDescription) {
        if (hovergenDescription == null) {
            throw new IllegalArgumentException();
        }
        this.hovergenDescription = hovergenDescription;
    }

    @Override
    public boolean hasHovergenDescription() {
        return !this.hovergenDescription.getValue().equals("");
    }
}

