/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.hogenom;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hogenom.Hogenom;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hogenom.HogenomAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hogenom.HogenomDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class HogenomImpl
extends DatabaseCrossReferenceImpl
implements Hogenom,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.HOGENOM;
    private long id = 0L;
    private HogenomAccessionNumber hogenomAccessionNumber = DefaultXRefFactory.getInstance().buildHogenomAccessionNumber("");
    private HogenomDescription hogenomDescription = DefaultXRefFactory.getInstance().buildHogenomDescription("");

    public HogenomImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getHogenomAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public HogenomImpl(HogenomImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasHogenomAccessionNumber()) {
            this.setHogenomAccessionNumber(toCopy.getHogenomAccessionNumber());
        }
        if (toCopy.hasHogenomDescription()) {
            this.setHogenomDescription(toCopy.getHogenomDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof HogenomImpl)) {
            return false;
        }
        HogenomImpl myClass = (HogenomImpl)o;
        if (!this.hogenomAccessionNumber.equals(myClass.getHogenomAccessionNumber())) {
            return false;
        }
        return this.hogenomDescription.equals(myClass.getHogenomDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.hogenomAccessionNumber != null ? this.hogenomAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.hogenomDescription != null ? this.hogenomDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.hogenomAccessionNumber + ":" + this.hogenomDescription + ";";
    }

    @Override
    public HogenomAccessionNumber getHogenomAccessionNumber() {
        return this.hogenomAccessionNumber;
    }

    @Override
    public void setHogenomAccessionNumber(HogenomAccessionNumber hogenomAccessionNumber) {
        if (hogenomAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.hogenomAccessionNumber = hogenomAccessionNumber;
    }

    @Override
    public boolean hasHogenomAccessionNumber() {
        return !this.hogenomAccessionNumber.getValue().equals("");
    }

    @Override
    public HogenomDescription getHogenomDescription() {
        return this.hogenomDescription;
    }

    @Override
    public void setHogenomDescription(HogenomDescription hogenomDescription) {
        if (hogenomDescription == null) {
            throw new IllegalArgumentException();
        }
        this.hogenomDescription = hogenomDescription;
    }

    @Override
    public boolean hasHogenomDescription() {
        return !this.hogenomDescription.getValue().equals("");
    }
}

