/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.hiv;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hiv.Hiv;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hiv.HivAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hiv.HivDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class HivImpl
extends DatabaseCrossReferenceImpl
implements Hiv,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.HIV;
    private long id = 0L;
    private HivAccessionNumber hivAccessionNumber = DefaultXRefFactory.getInstance().buildHivAccessionNumber("");
    private HivDescription hivDescription = DefaultXRefFactory.getInstance().buildHivDescription("");

    public HivImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getHivAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public HivImpl(HivImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasHivAccessionNumber()) {
            this.setHivAccessionNumber(toCopy.getHivAccessionNumber());
        }
        if (toCopy.hasHivDescription()) {
            this.setHivDescription(toCopy.getHivDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof HivImpl)) {
            return false;
        }
        HivImpl myClass = (HivImpl)o;
        if (!this.hivAccessionNumber.equals(myClass.getHivAccessionNumber())) {
            return false;
        }
        return this.hivDescription.equals(myClass.getHivDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.hivAccessionNumber != null ? this.hivAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.hivDescription != null ? this.hivDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.hivAccessionNumber + ":" + this.hivDescription + ";";
    }

    @Override
    public HivAccessionNumber getHivAccessionNumber() {
        return this.hivAccessionNumber;
    }

    @Override
    public void setHivAccessionNumber(HivAccessionNumber hivAccessionNumber) {
        if (hivAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.hivAccessionNumber = hivAccessionNumber;
    }

    @Override
    public boolean hasHivAccessionNumber() {
        return !this.hivAccessionNumber.getValue().equals("");
    }

    @Override
    public HivDescription getHivDescription() {
        return this.hivDescription;
    }

    @Override
    public void setHivDescription(HivDescription hivDescription) {
        if (hivDescription == null) {
            throw new IllegalArgumentException();
        }
        this.hivDescription = hivDescription;
    }

    @Override
    public boolean hasHivDescription() {
        return !this.hivDescription.getValue().equals("");
    }
}

