/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.hinvdb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hinvdb.Hinvdb;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hinvdb.HinvdbAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hinvdb.HinvdbDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class HinvdbImpl
extends DatabaseCrossReferenceImpl
implements Hinvdb,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.HINVDB;
    private long id = 0L;
    private HinvdbAccessionNumber hinvdbAccessionNumber = DefaultXRefFactory.getInstance().buildHinvdbAccessionNumber("");
    private HinvdbDescription hinvdbDescription = DefaultXRefFactory.getInstance().buildHinvdbDescription("");

    public HinvdbImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getHinvdbAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public HinvdbImpl(HinvdbImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasHinvdbAccessionNumber()) {
            this.setHinvdbAccessionNumber(toCopy.getHinvdbAccessionNumber());
        }
        if (toCopy.hasHinvdbDescription()) {
            this.setHinvdbDescription(toCopy.getHinvdbDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof HinvdbImpl)) {
            return false;
        }
        HinvdbImpl myClass = (HinvdbImpl)o;
        if (!this.hinvdbAccessionNumber.equals(myClass.getHinvdbAccessionNumber())) {
            return false;
        }
        return this.hinvdbDescription.equals(myClass.getHinvdbDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.hinvdbAccessionNumber != null ? this.hinvdbAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.hinvdbDescription != null ? this.hinvdbDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.hinvdbAccessionNumber + ":" + this.hinvdbDescription + ";";
    }

    @Override
    public HinvdbAccessionNumber getHinvdbAccessionNumber() {
        return this.hinvdbAccessionNumber;
    }

    @Override
    public void setHinvdbAccessionNumber(HinvdbAccessionNumber hinvdbAccessionNumber) {
        if (hinvdbAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.hinvdbAccessionNumber = hinvdbAccessionNumber;
    }

    @Override
    public boolean hasHinvdbAccessionNumber() {
        return !this.hinvdbAccessionNumber.getValue().equals("");
    }

    @Override
    public HinvdbDescription getHinvdbDescription() {
        return this.hinvdbDescription;
    }

    @Override
    public void setHinvdbDescription(HinvdbDescription hinvdbDescription) {
        if (hinvdbDescription == null) {
            throw new IllegalArgumentException();
        }
        this.hinvdbDescription = hinvdbDescription;
    }

    @Override
    public boolean hasHinvdbDescription() {
        return !this.hinvdbDescription.getValue().equals("");
    }
}

