/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.hgnc;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hgnc.Hgnc;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hgnc.HgncAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hgnc.HgncDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class HgncImpl
extends DatabaseCrossReferenceImpl
implements Hgnc,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.HGNC;
    private long id = 0L;
    private HgncAccessionNumber hgncAccessionNumber = DefaultXRefFactory.getInstance().buildHgncAccessionNumber("");
    private HgncDescription hgncDescription = DefaultXRefFactory.getInstance().buildHgncDescription("");

    public HgncImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getHgncAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public HgncImpl(HgncImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasHgncAccessionNumber()) {
            this.setHgncAccessionNumber(toCopy.getHgncAccessionNumber());
        }
        if (toCopy.hasHgncDescription()) {
            this.setHgncDescription(toCopy.getHgncDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof HgncImpl)) {
            return false;
        }
        HgncImpl myClass = (HgncImpl)o;
        if (!this.hgncAccessionNumber.equals(myClass.getHgncAccessionNumber())) {
            return false;
        }
        return this.hgncDescription.equals(myClass.getHgncDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.hgncAccessionNumber != null ? this.hgncAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.hgncDescription != null ? this.hgncDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.hgncAccessionNumber + ":" + this.hgncDescription + ";";
    }

    @Override
    public HgncAccessionNumber getHgncAccessionNumber() {
        return this.hgncAccessionNumber;
    }

    @Override
    public void setHgncAccessionNumber(HgncAccessionNumber hgncAccessionNumber) {
        if (hgncAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.hgncAccessionNumber = hgncAccessionNumber;
    }

    @Override
    public boolean hasHgncAccessionNumber() {
        return !this.hgncAccessionNumber.getValue().equals("");
    }

    @Override
    public HgncDescription getHgncDescription() {
        return this.hgncDescription;
    }

    @Override
    public void setHgncDescription(HgncDescription hgncDescription) {
        if (hgncDescription == null) {
            throw new IllegalArgumentException();
        }
        this.hgncDescription = hgncDescription;
    }

    @Override
    public boolean hasHgncDescription() {
        return !this.hgncDescription.getValue().equals("");
    }
}

