/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.hamap;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hamap.Hamap;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hamap.HamapAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hamap.HamapDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hamap.HamapHitNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.hamap.HamapNatureOfHit;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class HamapImpl
extends DatabaseCrossReferenceImpl
implements Hamap,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.HAMAP;
    private long id = 0L;
    private HamapAccessionNumber hamapAccessionNumber = DefaultXRefFactory.getInstance().buildHamapAccessionNumber("");
    private HamapDescription hamapDescription = DefaultXRefFactory.getInstance().buildHamapDescription("");
    private HamapHitNumber hamapHitNumber = DefaultXRefFactory.getInstance().buildHamapHitNumber("");
    private HamapNatureOfHit hamapNatureOfHit = DefaultXRefFactory.getInstance().buildHamapNatureOfHit("");

    public HamapImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getHamapAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public HamapImpl(HamapImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasHamapAccessionNumber()) {
            this.setHamapAccessionNumber(toCopy.getHamapAccessionNumber());
        }
        if (toCopy.hasHamapDescription()) {
            this.setHamapDescription(toCopy.getHamapDescription());
        }
        if (toCopy.hasHamapHitNumber()) {
            this.setHamapHitNumber(toCopy.getHamapHitNumber());
        }
        if (toCopy.hasHamapNatureOfHit()) {
            this.setHamapNatureOfHit(toCopy.getHamapNatureOfHit());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof HamapImpl)) {
            return false;
        }
        HamapImpl myClass = (HamapImpl)o;
        if (!this.hamapAccessionNumber.equals(myClass.getHamapAccessionNumber())) {
            return false;
        }
        if (!this.hamapDescription.equals(myClass.getHamapDescription())) {
            return false;
        }
        if (!this.hamapHitNumber.equals(myClass.getHamapHitNumber())) {
            return false;
        }
        return this.hamapNatureOfHit.equals(myClass.getHamapNatureOfHit());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.hamapAccessionNumber != null ? this.hamapAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.hamapDescription != null ? this.hamapDescription.hashCode() : 0);
        result = 29 * result + (this.hamapHitNumber != null ? this.hamapHitNumber.hashCode() : 0);
        result = 29 * result + (this.hamapNatureOfHit != null ? this.hamapNatureOfHit.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.hamapAccessionNumber + ":" + this.hamapDescription + ":" + this.hamapHitNumber + ":" + this.hamapNatureOfHit + ";";
    }

    @Override
    public HamapAccessionNumber getHamapAccessionNumber() {
        return this.hamapAccessionNumber;
    }

    @Override
    public void setHamapAccessionNumber(HamapAccessionNumber hamapAccessionNumber) {
        if (hamapAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.hamapAccessionNumber = hamapAccessionNumber;
    }

    @Override
    public boolean hasHamapAccessionNumber() {
        return !this.hamapAccessionNumber.getValue().equals("");
    }

    @Override
    public HamapDescription getHamapDescription() {
        return this.hamapDescription;
    }

    @Override
    public void setHamapDescription(HamapDescription hamapDescription) {
        if (hamapDescription == null) {
            throw new IllegalArgumentException();
        }
        this.hamapDescription = hamapDescription;
    }

    @Override
    public boolean hasHamapDescription() {
        return !this.hamapDescription.getValue().equals("");
    }

    @Override
    public HamapHitNumber getHamapHitNumber() {
        return this.hamapHitNumber;
    }

    @Override
    public void setHamapHitNumber(HamapHitNumber hamapHitNumber) {
        if (hamapHitNumber == null) {
            throw new IllegalArgumentException();
        }
        this.hamapHitNumber = hamapHitNumber;
    }

    @Override
    public boolean hasHamapHitNumber() {
        return !this.hamapHitNumber.getValue().equals("");
    }

    @Override
    public HamapNatureOfHit getHamapNatureOfHit() {
        return this.hamapNatureOfHit;
    }

    @Override
    public void setHamapNatureOfHit(HamapNatureOfHit hamapNatureOfHit) {
        if (hamapNatureOfHit == null) {
            throw new IllegalArgumentException();
        }
        this.hamapNatureOfHit = hamapNatureOfHit;
    }

    @Override
    public boolean hasHamapNatureOfHit() {
        return !this.hamapNatureOfHit.getValue().equals("");
    }
}

