/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.gramene;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gramene.Gramene;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gramene.GrameneAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gramene.GrameneDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class GrameneImpl
extends DatabaseCrossReferenceImpl
implements Gramene,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.GRAMENE;
    private long id = 0L;
    private GrameneAccessionNumber grameneAccessionNumber = DefaultXRefFactory.getInstance().buildGrameneAccessionNumber("");
    private GrameneDescription grameneDescription = DefaultXRefFactory.getInstance().buildGrameneDescription("");

    public GrameneImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getGrameneAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public GrameneImpl(GrameneImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasGrameneAccessionNumber()) {
            this.setGrameneAccessionNumber(toCopy.getGrameneAccessionNumber());
        }
        if (toCopy.hasGrameneDescription()) {
            this.setGrameneDescription(toCopy.getGrameneDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof GrameneImpl)) {
            return false;
        }
        GrameneImpl myClass = (GrameneImpl)o;
        if (!this.grameneAccessionNumber.equals(myClass.getGrameneAccessionNumber())) {
            return false;
        }
        return this.grameneDescription.equals(myClass.getGrameneDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.grameneAccessionNumber != null ? this.grameneAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.grameneDescription != null ? this.grameneDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.grameneAccessionNumber + ":" + this.grameneDescription + ";";
    }

    @Override
    public GrameneAccessionNumber getGrameneAccessionNumber() {
        return this.grameneAccessionNumber;
    }

    @Override
    public void setGrameneAccessionNumber(GrameneAccessionNumber grameneAccessionNumber) {
        if (grameneAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.grameneAccessionNumber = grameneAccessionNumber;
    }

    @Override
    public boolean hasGrameneAccessionNumber() {
        return !this.grameneAccessionNumber.getValue().equals("");
    }

    @Override
    public GrameneDescription getGrameneDescription() {
        return this.grameneDescription;
    }

    @Override
    public void setGrameneDescription(GrameneDescription grameneDescription) {
        if (grameneDescription == null) {
            throw new IllegalArgumentException();
        }
        this.grameneDescription = grameneDescription;
    }

    @Override
    public boolean hasGrameneDescription() {
        return !this.grameneDescription.getValue().equals("");
    }
}

