/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.go;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.Go;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoEvidenceSource;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoEvidenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoId;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoTerm;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.OntologyType;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class GoImpl
extends DatabaseCrossReferenceImpl
implements Go,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.GO;
    private long id = 0L;
    private GoId goId = DefaultXRefFactory.getInstance().buildGoId("");
    private GoEvidenceType goEvidenceType = GoEvidenceType.UNKNOWN;
    private GoTerm goTerm = DefaultXRefFactory.getInstance().buildGoTerm("");
    private GoEvidenceSource goEvidenceSource = DefaultXRefFactory.getInstance().buildGoEvidenceSource("");
    private OntologyType ontologyType = OntologyType.UNKNOWN;

    public GoImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getGoId().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public GoImpl(GoImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasGoId()) {
            this.setGoId(toCopy.getGoId());
        }
        this.setGoEvidenceType(toCopy.getGoEvidenceType());
        if (toCopy.hasGoTerm()) {
            this.setGoTerm(toCopy.getGoTerm());
        }
        if (toCopy.hasGoEvidenceSource()) {
            this.setGoEvidenceSource(toCopy.getGoEvidenceSource());
        }
        this.setOntologyType(toCopy.getOntologyType());
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof GoImpl)) {
            return false;
        }
        GoImpl myClass = (GoImpl)o;
        if (!this.goId.equals(myClass.getGoId())) {
            return false;
        }
        if (!this.goEvidenceType.equals(myClass.getGoEvidenceType())) {
            return false;
        }
        if (!this.goTerm.equals(myClass.getGoTerm())) {
            return false;
        }
        if (!this.goEvidenceSource.equals(myClass.getGoEvidenceSource())) {
            return false;
        }
        return this.ontologyType.equals(myClass.getOntologyType());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.goId != null ? this.goId.hashCode() : 0);
        result = 29 * result + (this.goEvidenceType != null ? this.goEvidenceType.hashCode() : 0);
        result = 29 * result + (this.goTerm != null ? this.goTerm.hashCode() : 0);
        result = 29 * result + (this.goEvidenceSource != null ? this.goEvidenceSource.hashCode() : 0);
        result = 29 * result + (this.ontologyType != null ? this.ontologyType.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.goId + ":" + this.goEvidenceType + ":" + this.goTerm + ":" + this.goEvidenceSource + ":" + this.ontologyType + ";";
    }

    @Override
    public GoId getGoId() {
        return this.goId;
    }

    @Override
    public void setGoId(GoId goId) {
        if (goId == null) {
            throw new IllegalArgumentException();
        }
        this.goId = goId;
    }

    @Override
    public boolean hasGoId() {
        return !this.goId.getValue().equals("");
    }

    @Override
    public GoEvidenceType getGoEvidenceType() {
        return this.goEvidenceType;
    }

    @Override
    public void setGoEvidenceType(GoEvidenceType goEvidenceType) {
        if (goEvidenceType == null) {
            throw new IllegalArgumentException();
        }
        this.goEvidenceType = goEvidenceType;
    }

    @Override
    public GoTerm getGoTerm() {
        return this.goTerm;
    }

    @Override
    public void setGoTerm(GoTerm goTerm) {
        if (goTerm == null) {
            throw new IllegalArgumentException();
        }
        this.goTerm = goTerm;
    }

    @Override
    public boolean hasGoTerm() {
        return !this.goTerm.getValue().equals("");
    }

    @Override
    public GoEvidenceSource getGoEvidenceSource() {
        return this.goEvidenceSource;
    }

    @Override
    public void setGoEvidenceSource(GoEvidenceSource goEvidenceSource) {
        if (goEvidenceSource == null) {
            throw new IllegalArgumentException();
        }
        this.goEvidenceSource = goEvidenceSource;
    }

    @Override
    public boolean hasGoEvidenceSource() {
        return !this.goEvidenceSource.getValue().equals("");
    }

    @Override
    public OntologyType getOntologyType() {
        return this.ontologyType;
    }

    @Override
    public void setOntologyType(OntologyType ontologyType) {
        if (ontologyType == null) {
            throw new IllegalArgumentException();
        }
        this.ontologyType = ontologyType;
    }
}

