/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.gk;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gk.Gk;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gk.GkAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gk.GkDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class GkImpl
extends DatabaseCrossReferenceImpl
implements Gk,
PersistentObject {
    private DatabaseType databaseType = DatabaseType.GK;
    private long id = 0L;
    private GkAccessionNumber gkAccessionNumber = DefaultXRefFactory.getInstance().buildGkAccessionNumber("");
    private GkDescription gkDescription = DefaultXRefFactory.getInstance().buildGkDescription("");

    public GkImpl() {
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public GkImpl(GkImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasGkAccessionNumber()) {
            this.setGkAccessionNumber(toCopy.getGkAccessionNumber());
        }
        if (toCopy.hasGkDescription()) {
            this.setGkDescription(toCopy.getGkDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof GkImpl)) {
            return false;
        }
        GkImpl myClass = (GkImpl)o;
        if (!this.gkAccessionNumber.equals(myClass.getGkAccessionNumber())) {
            return false;
        }
        return this.gkDescription.equals(myClass.getGkDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.gkAccessionNumber != null ? this.gkAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.gkDescription != null ? this.gkDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.gkAccessionNumber + ":" + this.gkDescription + ";";
    }

    @Override
    public GkAccessionNumber getGkAccessionNumber() {
        return this.gkAccessionNumber;
    }

    @Override
    public void setGkAccessionNumber(GkAccessionNumber gkAccessionNumber) {
        if (gkAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.gkAccessionNumber = gkAccessionNumber;
    }

    @Override
    public boolean hasGkAccessionNumber() {
        return !this.gkAccessionNumber.getValue().equals("");
    }

    @Override
    public GkDescription getGkDescription() {
        return this.gkDescription;
    }

    @Override
    public void setGkDescription(GkDescription gkDescription) {
        if (gkDescription == null) {
            throw new IllegalArgumentException();
        }
        this.gkDescription = gkDescription;
    }

    @Override
    public boolean hasGkDescription() {
        return !this.gkDescription.getValue().equals("");
    }
}

