/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.germonline;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.germonline.GermOnline;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.germonline.GermOnlineAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.germonline.GermOnlineDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class GermOnlineImpl
extends DatabaseCrossReferenceImpl
implements GermOnline,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.GERMONLINE;
    private long id = 0L;
    private GermOnlineAccessionNumber germOnlineAccessionNumber = DefaultXRefFactory.getInstance().buildGermOnlineAccessionNumber("");
    private GermOnlineDescription germOnlineDescription = DefaultXRefFactory.getInstance().buildGermOnlineDescription("");

    public GermOnlineImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getGermOnlineAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public GermOnlineImpl(GermOnlineImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasGermOnlineAccessionNumber()) {
            this.setGermOnlineAccessionNumber(toCopy.getGermOnlineAccessionNumber());
        }
        if (toCopy.hasGermOnlineDescription()) {
            this.setGermOnlineDescription(toCopy.getGermOnlineDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof GermOnlineImpl)) {
            return false;
        }
        GermOnlineImpl myClass = (GermOnlineImpl)o;
        if (!this.germOnlineAccessionNumber.equals(myClass.getGermOnlineAccessionNumber())) {
            return false;
        }
        return this.germOnlineDescription.equals(myClass.getGermOnlineDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.germOnlineAccessionNumber != null ? this.germOnlineAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.germOnlineDescription != null ? this.germOnlineDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.germOnlineAccessionNumber + ":" + this.germOnlineDescription + ";";
    }

    @Override
    public GermOnlineAccessionNumber getGermOnlineAccessionNumber() {
        return this.germOnlineAccessionNumber;
    }

    @Override
    public void setGermOnlineAccessionNumber(GermOnlineAccessionNumber germOnlineAccessionNumber) {
        if (germOnlineAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.germOnlineAccessionNumber = germOnlineAccessionNumber;
    }

    @Override
    public boolean hasGermOnlineAccessionNumber() {
        return !this.germOnlineAccessionNumber.getValue().equals("");
    }

    @Override
    public GermOnlineDescription getGermOnlineDescription() {
        return this.germOnlineDescription;
    }

    @Override
    public void setGermOnlineDescription(GermOnlineDescription germOnlineDescription) {
        if (germOnlineDescription == null) {
            throw new IllegalArgumentException();
        }
        this.germOnlineDescription = germOnlineDescription;
    }

    @Override
    public boolean hasGermOnlineDescription() {
        return !this.germOnlineDescription.getValue().equals("");
    }
}

