/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.genolist;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genolist.GenoList;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genolist.GenoListAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genolist.GenoListDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class GenoListImpl
extends DatabaseCrossReferenceImpl
implements GenoList,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.GENOLIST;
    private long id = 0L;
    private GenoListAccessionNumber genoListAccessionNumber = DefaultXRefFactory.getInstance().buildGenoListAccessionNumber("");
    private GenoListDescription genoListDescription = DefaultXRefFactory.getInstance().buildGenoListDescription("");

    public GenoListImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getGenoListAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public GenoListImpl(GenoListImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasGenoListAccessionNumber()) {
            this.setGenoListAccessionNumber(toCopy.getGenoListAccessionNumber());
        }
        if (toCopy.hasGenoListDescription()) {
            this.setGenoListDescription(toCopy.getGenoListDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenoListImpl)) {
            return false;
        }
        GenoListImpl myClass = (GenoListImpl)o;
        if (!this.genoListAccessionNumber.equals(myClass.getGenoListAccessionNumber())) {
            return false;
        }
        return this.genoListDescription.equals(myClass.getGenoListDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.genoListAccessionNumber != null ? this.genoListAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.genoListDescription != null ? this.genoListDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.genoListAccessionNumber + ":" + this.genoListDescription + ";";
    }

    @Override
    public GenoListAccessionNumber getGenoListAccessionNumber() {
        return this.genoListAccessionNumber;
    }

    @Override
    public void setGenoListAccessionNumber(GenoListAccessionNumber genoListAccessionNumber) {
        if (genoListAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.genoListAccessionNumber = genoListAccessionNumber;
    }

    @Override
    public boolean hasGenoListAccessionNumber() {
        return !this.genoListAccessionNumber.getValue().equals("");
    }

    @Override
    public GenoListDescription getGenoListDescription() {
        return this.genoListDescription;
    }

    @Override
    public void setGenoListDescription(GenoListDescription genoListDescription) {
        if (genoListDescription == null) {
            throw new IllegalArgumentException();
        }
        this.genoListDescription = genoListDescription;
    }

    @Override
    public boolean hasGenoListDescription() {
        return !this.genoListDescription.getValue().equals("");
    }
}

