/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.genew;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genew.Genew;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genew.GenewAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genew.GenewDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class GenewImpl
extends DatabaseCrossReferenceImpl
implements Genew,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.GENEW;
    private long id = 0L;
    private GenewAccessionNumber genewAccessionNumber = DefaultXRefFactory.getInstance().buildGenewAccessionNumber("");
    private GenewDescription genewDescription = DefaultXRefFactory.getInstance().buildGenewDescription("");

    public GenewImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getGenewAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public GenewImpl(GenewImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasGenewAccessionNumber()) {
            this.setGenewAccessionNumber(toCopy.getGenewAccessionNumber());
        }
        if (toCopy.hasGenewDescription()) {
            this.setGenewDescription(toCopy.getGenewDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenewImpl)) {
            return false;
        }
        GenewImpl myClass = (GenewImpl)o;
        if (!this.genewAccessionNumber.equals(myClass.getGenewAccessionNumber())) {
            return false;
        }
        return this.genewDescription.equals(myClass.getGenewDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.genewAccessionNumber != null ? this.genewAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.genewDescription != null ? this.genewDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.genewAccessionNumber + ":" + this.genewDescription + ";";
    }

    @Override
    public GenewAccessionNumber getGenewAccessionNumber() {
        return this.genewAccessionNumber;
    }

    @Override
    public void setGenewAccessionNumber(GenewAccessionNumber genewAccessionNumber) {
        if (genewAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.genewAccessionNumber = genewAccessionNumber;
    }

    @Override
    public boolean hasGenewAccessionNumber() {
        return !this.genewAccessionNumber.getValue().equals("");
    }

    @Override
    public GenewDescription getGenewDescription() {
        return this.genewDescription;
    }

    @Override
    public void setGenewDescription(GenewDescription genewDescription) {
        if (genewDescription == null) {
            throw new IllegalArgumentException();
        }
        this.genewDescription = genewDescription;
    }

    @Override
    public boolean hasGenewDescription() {
        return !this.genewDescription.getValue().equals("");
    }
}

