/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.genetree;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genetree.GeneTree;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genetree.GeneTreeDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genetree.GeneTreeIdentifier;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class GeneTreeImpl
extends DatabaseCrossReferenceImpl
implements GeneTree,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.GENETREE;
    private long id = 0L;
    private GeneTreeIdentifier geneTreeIdentifier = DefaultXRefFactory.getInstance().buildGeneTreeIdentifier("");
    private GeneTreeDescription geneTreeDescription = DefaultXRefFactory.getInstance().buildGeneTreeDescription("");

    public GeneTreeImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getGeneTreeIdentifier().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public GeneTreeImpl(GeneTreeImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasGeneTreeIdentifier()) {
            this.setGeneTreeIdentifier(toCopy.getGeneTreeIdentifier());
        }
        if (toCopy.hasGeneTreeDescription()) {
            this.setGeneTreeDescription(toCopy.getGeneTreeDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeneTreeImpl)) {
            return false;
        }
        GeneTreeImpl myClass = (GeneTreeImpl)o;
        if (!this.geneTreeIdentifier.equals(myClass.getGeneTreeIdentifier())) {
            return false;
        }
        return this.geneTreeDescription.equals(myClass.getGeneTreeDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.geneTreeIdentifier != null ? this.geneTreeIdentifier.hashCode() : 0);
        result = 29 * result + (this.geneTreeDescription != null ? this.geneTreeDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.geneTreeIdentifier + ":" + this.geneTreeDescription + ";";
    }

    @Override
    public GeneTreeIdentifier getGeneTreeIdentifier() {
        return this.geneTreeIdentifier;
    }

    @Override
    public void setGeneTreeIdentifier(GeneTreeIdentifier geneTreeIdentifier) {
        if (geneTreeIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.geneTreeIdentifier = geneTreeIdentifier;
    }

    @Override
    public boolean hasGeneTreeIdentifier() {
        return !this.geneTreeIdentifier.getValue().equals("");
    }

    @Override
    public GeneTreeDescription getGeneTreeDescription() {
        return this.geneTreeDescription;
    }

    @Override
    public void setGeneTreeDescription(GeneTreeDescription geneTreeDescription) {
        if (geneTreeDescription == null) {
            throw new IllegalArgumentException();
        }
        this.geneTreeDescription = geneTreeDescription;
    }

    @Override
    public boolean hasGeneTreeDescription() {
        return !this.geneTreeDescription.getValue().equals("");
    }
}

