/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.geneid;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.geneid.GeneId;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.geneid.GeneIdAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.geneid.GeneIdDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class GeneIdImpl
extends DatabaseCrossReferenceImpl
implements GeneId,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.GENEID;
    private long id = 0L;
    private GeneIdAccessionNumber geneIdAccessionNumber = DefaultXRefFactory.getInstance().buildGeneIdAccessionNumber("");
    private GeneIdDescription geneIdDescription = DefaultXRefFactory.getInstance().buildGeneIdDescription("");

    public GeneIdImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getGeneIdAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public GeneIdImpl(GeneIdImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasGeneIdAccessionNumber()) {
            this.setGeneIdAccessionNumber(toCopy.getGeneIdAccessionNumber());
        }
        if (toCopy.hasGeneIdDescription()) {
            this.setGeneIdDescription(toCopy.getGeneIdDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeneIdImpl)) {
            return false;
        }
        GeneIdImpl myClass = (GeneIdImpl)o;
        if (!this.geneIdAccessionNumber.equals(myClass.getGeneIdAccessionNumber())) {
            return false;
        }
        return this.geneIdDescription.equals(myClass.getGeneIdDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.geneIdAccessionNumber != null ? this.geneIdAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.geneIdDescription != null ? this.geneIdDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.geneIdAccessionNumber + ":" + this.geneIdDescription + ";";
    }

    @Override
    public GeneIdAccessionNumber getGeneIdAccessionNumber() {
        return this.geneIdAccessionNumber;
    }

    @Override
    public void setGeneIdAccessionNumber(GeneIdAccessionNumber geneIdAccessionNumber) {
        if (geneIdAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.geneIdAccessionNumber = geneIdAccessionNumber;
    }

    @Override
    public boolean hasGeneIdAccessionNumber() {
        return !this.geneIdAccessionNumber.getValue().equals("");
    }

    @Override
    public GeneIdDescription getGeneIdDescription() {
        return this.geneIdDescription;
    }

    @Override
    public void setGeneIdDescription(GeneIdDescription geneIdDescription) {
        if (geneIdDescription == null) {
            throw new IllegalArgumentException();
        }
        this.geneIdDescription = geneIdDescription;
    }

    @Override
    public boolean hasGeneIdDescription() {
        return !this.geneIdDescription.getValue().equals("");
    }
}

