/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.genecards;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genecards.GeneCards;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genecards.GeneCardsAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.genecards.GeneCardsDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class GeneCardsImpl
extends DatabaseCrossReferenceImpl
implements GeneCards,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.GENECARDS;
    private long id = 0L;
    private GeneCardsAccessionNumber geneCardsAccessionNumber = DefaultXRefFactory.getInstance().buildGeneCardsAccessionNumber("");
    private GeneCardsDescription geneCardsDescription = DefaultXRefFactory.getInstance().buildGeneCardsDescription("");

    public GeneCardsImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getGeneCardsAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public GeneCardsImpl(GeneCardsImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasGeneCardsAccessionNumber()) {
            this.setGeneCardsAccessionNumber(toCopy.getGeneCardsAccessionNumber());
        }
        if (toCopy.hasGeneCardsDescription()) {
            this.setGeneCardsDescription(toCopy.getGeneCardsDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeneCardsImpl)) {
            return false;
        }
        GeneCardsImpl myClass = (GeneCardsImpl)o;
        if (!this.geneCardsAccessionNumber.equals(myClass.getGeneCardsAccessionNumber())) {
            return false;
        }
        return this.geneCardsDescription.equals(myClass.getGeneCardsDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.geneCardsAccessionNumber != null ? this.geneCardsAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.geneCardsDescription != null ? this.geneCardsDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.geneCardsAccessionNumber + ":" + this.geneCardsDescription + ";";
    }

    @Override
    public GeneCardsAccessionNumber getGeneCardsAccessionNumber() {
        return this.geneCardsAccessionNumber;
    }

    @Override
    public void setGeneCardsAccessionNumber(GeneCardsAccessionNumber geneCardsAccessionNumber) {
        if (geneCardsAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.geneCardsAccessionNumber = geneCardsAccessionNumber;
    }

    @Override
    public boolean hasGeneCardsAccessionNumber() {
        return !this.geneCardsAccessionNumber.getValue().equals("");
    }

    @Override
    public GeneCardsDescription getGeneCardsDescription() {
        return this.geneCardsDescription;
    }

    @Override
    public void setGeneCardsDescription(GeneCardsDescription geneCardsDescription) {
        if (geneCardsDescription == null) {
            throw new IllegalArgumentException();
        }
        this.geneCardsDescription = geneCardsDescription;
    }

    @Override
    public boolean hasGeneCardsDescription() {
        return !this.geneCardsDescription.getValue().equals("");
    }
}

