/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.gene3d;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gene3d.Gene3D;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gene3d.Gene3DAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gene3d.Gene3DDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gene3d.Gene3DHitNumber;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class Gene3DImpl
extends DatabaseCrossReferenceImpl
implements Gene3D,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.GENE3D;
    private long id = 0L;
    private Gene3DAccessionNumber gene3DAccessionNumber = DefaultXRefFactory.getInstance().buildGene3DAccessionNumber("");
    private Gene3DDescription gene3DDescription = DefaultXRefFactory.getInstance().buildGene3DDescription("");
    private Gene3DHitNumber gene3DHitNumber = DefaultXRefFactory.getInstance().buildGene3DHitNumber("");

    public Gene3DImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getGene3DAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public Gene3DImpl(Gene3DImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasGene3DAccessionNumber()) {
            this.setGene3DAccessionNumber(toCopy.getGene3DAccessionNumber());
        }
        if (toCopy.hasGene3DDescription()) {
            this.setGene3DDescription(toCopy.getGene3DDescription());
        }
        if (toCopy.hasGene3DHitNumber()) {
            this.setGene3DHitNumber(toCopy.getGene3DHitNumber());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Gene3DImpl)) {
            return false;
        }
        Gene3DImpl myClass = (Gene3DImpl)o;
        if (!this.gene3DAccessionNumber.equals(myClass.getGene3DAccessionNumber())) {
            return false;
        }
        if (!this.gene3DDescription.equals(myClass.getGene3DDescription())) {
            return false;
        }
        return this.gene3DHitNumber.equals(myClass.getGene3DHitNumber());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.gene3DAccessionNumber != null ? this.gene3DAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.gene3DDescription != null ? this.gene3DDescription.hashCode() : 0);
        result = 29 * result + (this.gene3DHitNumber != null ? this.gene3DHitNumber.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.gene3DAccessionNumber + ":" + this.gene3DDescription + ":" + this.gene3DHitNumber + ";";
    }

    @Override
    public Gene3DAccessionNumber getGene3DAccessionNumber() {
        return this.gene3DAccessionNumber;
    }

    @Override
    public void setGene3DAccessionNumber(Gene3DAccessionNumber gene3DAccessionNumber) {
        if (gene3DAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.gene3DAccessionNumber = gene3DAccessionNumber;
    }

    @Override
    public boolean hasGene3DAccessionNumber() {
        return !this.gene3DAccessionNumber.getValue().equals("");
    }

    @Override
    public Gene3DDescription getGene3DDescription() {
        return this.gene3DDescription;
    }

    @Override
    public void setGene3DDescription(Gene3DDescription gene3DDescription) {
        if (gene3DDescription == null) {
            throw new IllegalArgumentException();
        }
        this.gene3DDescription = gene3DDescription;
    }

    @Override
    public boolean hasGene3DDescription() {
        return !this.gene3DDescription.getValue().equals("");
    }

    @Override
    public Gene3DHitNumber getGene3DHitNumber() {
        return this.gene3DHitNumber;
    }

    @Override
    public void setGene3DHitNumber(Gene3DHitNumber gene3DHitNumber) {
        if (gene3DHitNumber == null) {
            throw new IllegalArgumentException();
        }
        this.gene3DHitNumber = gene3DHitNumber;
    }

    @Override
    public boolean hasGene3DHitNumber() {
        return !this.gene3DHitNumber.getValue().equals("");
    }
}

