/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.gcrdb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gcrdb.Gcrdb;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gcrdb.GcrdbAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.gcrdb.GcrdbDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class GcrdbImpl
extends DatabaseCrossReferenceImpl
implements Gcrdb,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.GCRDB;
    private long id = 0L;
    private GcrdbAccessionNumber gcrdbAccessionNumber = DefaultXRefFactory.getInstance().buildGcrdbAccessionNumber("");
    private GcrdbDescription gcrdbDescription = DefaultXRefFactory.getInstance().buildGcrdbDescription("");

    public GcrdbImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getGcrdbAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public GcrdbImpl(GcrdbImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasGcrdbAccessionNumber()) {
            this.setGcrdbAccessionNumber(toCopy.getGcrdbAccessionNumber());
        }
        if (toCopy.hasGcrdbDescription()) {
            this.setGcrdbDescription(toCopy.getGcrdbDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof GcrdbImpl)) {
            return false;
        }
        GcrdbImpl myClass = (GcrdbImpl)o;
        if (!this.gcrdbAccessionNumber.equals(myClass.getGcrdbAccessionNumber())) {
            return false;
        }
        return this.gcrdbDescription.equals(myClass.getGcrdbDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.gcrdbAccessionNumber != null ? this.gcrdbAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.gcrdbDescription != null ? this.gcrdbDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.gcrdbAccessionNumber + ":" + this.gcrdbDescription + ";";
    }

    @Override
    public GcrdbAccessionNumber getGcrdbAccessionNumber() {
        return this.gcrdbAccessionNumber;
    }

    @Override
    public void setGcrdbAccessionNumber(GcrdbAccessionNumber gcrdbAccessionNumber) {
        if (gcrdbAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.gcrdbAccessionNumber = gcrdbAccessionNumber;
    }

    @Override
    public boolean hasGcrdbAccessionNumber() {
        return !this.gcrdbAccessionNumber.getValue().equals("");
    }

    @Override
    public GcrdbDescription getGcrdbDescription() {
        return this.gcrdbDescription;
    }

    @Override
    public void setGcrdbDescription(GcrdbDescription gcrdbDescription) {
        if (gcrdbDescription == null) {
            throw new IllegalArgumentException();
        }
        this.gcrdbDescription = gcrdbDescription;
    }

    @Override
    public boolean hasGcrdbDescription() {
        return !this.gcrdbDescription.getValue().equals("");
    }
}

