/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.flybase;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.flybase.FlyBase;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.flybase.FlyBaseAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.flybase.FlyBaseGenName;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class FlyBaseImpl
extends DatabaseCrossReferenceImpl
implements FlyBase,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.FLYBASE;
    private long id = 0L;
    private FlyBaseAccessionNumber flyBaseAccessionNumber = DefaultXRefFactory.getInstance().buildFlyBaseAccessionNumber("");
    private FlyBaseGenName flyBaseGenName = DefaultXRefFactory.getInstance().buildFlyBaseGenName("");

    public FlyBaseImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getFlyBaseAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public FlyBaseImpl(FlyBaseImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasFlyBaseAccessionNumber()) {
            this.setFlyBaseAccessionNumber(toCopy.getFlyBaseAccessionNumber());
        }
        if (toCopy.hasFlyBaseGenName()) {
            this.setFlyBaseGenName(toCopy.getFlyBaseGenName());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlyBaseImpl)) {
            return false;
        }
        FlyBaseImpl myClass = (FlyBaseImpl)o;
        if (!this.flyBaseAccessionNumber.equals(myClass.getFlyBaseAccessionNumber())) {
            return false;
        }
        return this.flyBaseGenName.equals(myClass.getFlyBaseGenName());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.flyBaseAccessionNumber != null ? this.flyBaseAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.flyBaseGenName != null ? this.flyBaseGenName.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.flyBaseAccessionNumber + ":" + this.flyBaseGenName + ";";
    }

    @Override
    public FlyBaseAccessionNumber getFlyBaseAccessionNumber() {
        return this.flyBaseAccessionNumber;
    }

    @Override
    public void setFlyBaseAccessionNumber(FlyBaseAccessionNumber flyBaseAccessionNumber) {
        if (flyBaseAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.flyBaseAccessionNumber = flyBaseAccessionNumber;
    }

    @Override
    public boolean hasFlyBaseAccessionNumber() {
        return !this.flyBaseAccessionNumber.getValue().equals("");
    }

    @Override
    public FlyBaseGenName getFlyBaseGenName() {
        return this.flyBaseGenName;
    }

    @Override
    public void setFlyBaseGenName(FlyBaseGenName flyBaseGenName) {
        if (flyBaseGenName == null) {
            throw new IllegalArgumentException();
        }
        this.flyBaseGenName = flyBaseGenName;
    }

    @Override
    public boolean hasFlyBaseGenName() {
        return !this.flyBaseGenName.getValue().equals("");
    }
}

