/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.eupathdb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.eupathdb.EuPathDB;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.eupathdb.EuPathDBAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.eupathdb.EuPathDBDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class EuPathDBImpl
extends DatabaseCrossReferenceImpl
implements EuPathDB,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.EUPATHDB;
    private long id = 0L;
    private EuPathDBAccessionNumber euPathDBAccessionNumber = DefaultXRefFactory.getInstance().buildEuPathDBAccessionNumber("");
    private EuPathDBDescription euPathDBDescription = DefaultXRefFactory.getInstance().buildEuPathDBDescription("");

    public EuPathDBImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getEuPathDBAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public EuPathDBImpl(EuPathDBImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasEuPathDBAccessionNumber()) {
            this.setEuPathDBAccessionNumber(toCopy.getEuPathDBAccessionNumber());
        }
        if (toCopy.hasEuPathDBDescription()) {
            this.setEuPathDBDescription(toCopy.getEuPathDBDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof EuPathDBImpl)) {
            return false;
        }
        EuPathDBImpl myClass = (EuPathDBImpl)o;
        if (!this.euPathDBAccessionNumber.equals(myClass.getEuPathDBAccessionNumber())) {
            return false;
        }
        return this.euPathDBDescription.equals(myClass.getEuPathDBDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.euPathDBAccessionNumber != null ? this.euPathDBAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.euPathDBDescription != null ? this.euPathDBDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.euPathDBAccessionNumber + ":" + this.euPathDBDescription + ";";
    }

    @Override
    public EuPathDBAccessionNumber getEuPathDBAccessionNumber() {
        return this.euPathDBAccessionNumber;
    }

    @Override
    public void setEuPathDBAccessionNumber(EuPathDBAccessionNumber euPathDBAccessionNumber) {
        if (euPathDBAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.euPathDBAccessionNumber = euPathDBAccessionNumber;
    }

    @Override
    public boolean hasEuPathDBAccessionNumber() {
        return !this.euPathDBAccessionNumber.getValue().equals("");
    }

    @Override
    public EuPathDBDescription getEuPathDBDescription() {
        return this.euPathDBDescription;
    }

    @Override
    public void setEuPathDBDescription(EuPathDBDescription euPathDBDescription) {
        if (euPathDBDescription == null) {
            throw new IllegalArgumentException();
        }
        this.euPathDBDescription = euPathDBDescription;
    }

    @Override
    public boolean hasEuPathDBDescription() {
        return !this.euPathDBDescription.getValue().equals("");
    }
}

