/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.euhcvdb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.euhcvdb.EuHCVdb;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.euhcvdb.EuHCVdbAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.euhcvdb.EuHCVdbDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class EuHCVdbImpl
extends DatabaseCrossReferenceImpl
implements EuHCVdb,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.EUHCVDB;
    private long id = 0L;
    private EuHCVdbAccessionNumber euHCVdbAccessionNumber = DefaultXRefFactory.getInstance().buildEuHCVdbAccessionNumber("");
    private EuHCVdbDescription euHCVdbDescription = DefaultXRefFactory.getInstance().buildEuHCVdbDescription("");

    public EuHCVdbImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getEuHCVdbAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public EuHCVdbImpl(EuHCVdbImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasEuHCVdbAccessionNumber()) {
            this.setEuHCVdbAccessionNumber(toCopy.getEuHCVdbAccessionNumber());
        }
        if (toCopy.hasEuHCVdbDescription()) {
            this.setEuHCVdbDescription(toCopy.getEuHCVdbDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof EuHCVdbImpl)) {
            return false;
        }
        EuHCVdbImpl myClass = (EuHCVdbImpl)o;
        if (!this.euHCVdbAccessionNumber.equals(myClass.getEuHCVdbAccessionNumber())) {
            return false;
        }
        return this.euHCVdbDescription.equals(myClass.getEuHCVdbDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.euHCVdbAccessionNumber != null ? this.euHCVdbAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.euHCVdbDescription != null ? this.euHCVdbDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.euHCVdbAccessionNumber + ":" + this.euHCVdbDescription + ";";
    }

    @Override
    public EuHCVdbAccessionNumber getEuHCVdbAccessionNumber() {
        return this.euHCVdbAccessionNumber;
    }

    @Override
    public void setEuHCVdbAccessionNumber(EuHCVdbAccessionNumber euHCVdbAccessionNumber) {
        if (euHCVdbAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.euHCVdbAccessionNumber = euHCVdbAccessionNumber;
    }

    @Override
    public boolean hasEuHCVdbAccessionNumber() {
        return !this.euHCVdbAccessionNumber.getValue().equals("");
    }

    @Override
    public EuHCVdbDescription getEuHCVdbDescription() {
        return this.euHCVdbDescription;
    }

    @Override
    public void setEuHCVdbDescription(EuHCVdbDescription euHCVdbDescription) {
        if (euHCVdbDescription == null) {
            throw new IllegalArgumentException();
        }
        this.euHCVdbDescription = euHCVdbDescription;
    }

    @Override
    public boolean hasEuHCVdbDescription() {
        return !this.euHCVdbDescription.getValue().equals("");
    }
}

