/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.ensembl;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ensembl.Ensembl;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ensembl.EnsemblGeneIdentifier;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ensembl.EnsemblProteinIdentifier;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ensembl.EnsemblTranscriptIdentifier;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class EnsemblImpl
extends DatabaseCrossReferenceImpl
implements Ensembl,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.ENSEMBL;
    private long id = 0L;
    private EnsemblTranscriptIdentifier ensemblTranscriptIdentifier = DefaultXRefFactory.getInstance().buildEnsemblTranscriptIdentifier("");
    private EnsemblProteinIdentifier ensemblProteinIdentifier = DefaultXRefFactory.getInstance().buildEnsemblProteinIdentifier("");
    private EnsemblGeneIdentifier ensemblGeneIdentifier = DefaultXRefFactory.getInstance().buildEnsemblGeneIdentifier("");

    public EnsemblImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getEnsemblTranscriptIdentifier().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public EnsemblImpl(EnsemblImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasEnsemblTranscriptIdentifier()) {
            this.setEnsemblTranscriptIdentifier(toCopy.getEnsemblTranscriptIdentifier());
        }
        if (toCopy.hasEnsemblProteinIdentifier()) {
            this.setEnsemblProteinIdentifier(toCopy.getEnsemblProteinIdentifier());
        }
        if (toCopy.hasEnsemblGeneIdentifier()) {
            this.setEnsemblGeneIdentifier(toCopy.getEnsemblGeneIdentifier());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnsemblImpl)) {
            return false;
        }
        EnsemblImpl myClass = (EnsemblImpl)o;
        if (!this.ensemblTranscriptIdentifier.equals(myClass.getEnsemblTranscriptIdentifier())) {
            return false;
        }
        if (!this.ensemblProteinIdentifier.equals(myClass.getEnsemblProteinIdentifier())) {
            return false;
        }
        return this.ensemblGeneIdentifier.equals(myClass.getEnsemblGeneIdentifier());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.ensemblTranscriptIdentifier != null ? this.ensemblTranscriptIdentifier.hashCode() : 0);
        result = 29 * result + (this.ensemblProteinIdentifier != null ? this.ensemblProteinIdentifier.hashCode() : 0);
        result = 29 * result + (this.ensemblGeneIdentifier != null ? this.ensemblGeneIdentifier.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.ensemblTranscriptIdentifier + ":" + this.ensemblProteinIdentifier + ":" + this.ensemblGeneIdentifier + ";";
    }

    @Override
    public EnsemblTranscriptIdentifier getEnsemblTranscriptIdentifier() {
        return this.ensemblTranscriptIdentifier;
    }

    @Override
    public void setEnsemblTranscriptIdentifier(EnsemblTranscriptIdentifier ensemblTranscriptIdentifier) {
        if (ensemblTranscriptIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.ensemblTranscriptIdentifier = ensemblTranscriptIdentifier;
    }

    @Override
    public boolean hasEnsemblTranscriptIdentifier() {
        return !this.ensemblTranscriptIdentifier.getValue().equals("");
    }

    @Override
    public EnsemblProteinIdentifier getEnsemblProteinIdentifier() {
        return this.ensemblProteinIdentifier;
    }

    @Override
    public void setEnsemblProteinIdentifier(EnsemblProteinIdentifier ensemblProteinIdentifier) {
        if (ensemblProteinIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.ensemblProteinIdentifier = ensemblProteinIdentifier;
    }

    @Override
    public boolean hasEnsemblProteinIdentifier() {
        return !this.ensemblProteinIdentifier.getValue().equals("");
    }

    @Override
    public EnsemblGeneIdentifier getEnsemblGeneIdentifier() {
        return this.ensemblGeneIdentifier;
    }

    @Override
    public void setEnsemblGeneIdentifier(EnsemblGeneIdentifier ensemblGeneIdentifier) {
        if (ensemblGeneIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.ensemblGeneIdentifier = ensemblGeneIdentifier;
    }

    @Override
    public boolean hasEnsemblGeneIdentifier() {
        return !this.ensemblGeneIdentifier.getValue().equals("");
    }
}

