/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.embl;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.embl.Embl;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.embl.EmblAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.embl.EmblMoleculeType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.embl.EmblProteinId;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.embl.EmblStatusIdentifier;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class EmblImpl
extends DatabaseCrossReferenceImpl
implements Embl,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.EMBL;
    private long id = 0L;
    private EmblAccessionNumber emblAccessionNumber = DefaultXRefFactory.getInstance().buildEmblAccessionNumber("");
    private EmblProteinId emblProteinId = DefaultXRefFactory.getInstance().buildEmblProteinId("");
    private EmblStatusIdentifier emblStatusIdentifier = DefaultXRefFactory.getInstance().buildEmblStatusIdentifier("");
    private EmblMoleculeType emblMoleculeType = DefaultXRefFactory.getInstance().buildEmblMoleculeType("");

    public EmblImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getEmblAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public EmblImpl(EmblImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasEmblAccessionNumber()) {
            this.setEmblAccessionNumber(toCopy.getEmblAccessionNumber());
        }
        if (toCopy.hasEmblProteinId()) {
            this.setEmblProteinId(toCopy.getEmblProteinId());
        }
        if (toCopy.hasEmblStatusIdentifier()) {
            this.setEmblStatusIdentifier(toCopy.getEmblStatusIdentifier());
        }
        if (toCopy.hasEmblMoleculeType()) {
            this.setEmblMoleculeType(toCopy.getEmblMoleculeType());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmblImpl)) {
            return false;
        }
        EmblImpl myClass = (EmblImpl)o;
        if (!this.emblAccessionNumber.equals(myClass.getEmblAccessionNumber())) {
            return false;
        }
        if (!this.emblProteinId.equals(myClass.getEmblProteinId())) {
            return false;
        }
        if (!this.emblStatusIdentifier.equals(myClass.getEmblStatusIdentifier())) {
            return false;
        }
        return this.emblMoleculeType.equals(myClass.getEmblMoleculeType());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.emblAccessionNumber != null ? this.emblAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.emblProteinId != null ? this.emblProteinId.hashCode() : 0);
        result = 29 * result + (this.emblStatusIdentifier != null ? this.emblStatusIdentifier.hashCode() : 0);
        result = 29 * result + (this.emblMoleculeType != null ? this.emblMoleculeType.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.emblAccessionNumber + ":" + this.emblProteinId + ":" + this.emblStatusIdentifier + ":" + this.emblMoleculeType + ";";
    }

    @Override
    public EmblAccessionNumber getEmblAccessionNumber() {
        return this.emblAccessionNumber;
    }

    @Override
    public void setEmblAccessionNumber(EmblAccessionNumber emblAccessionNumber) {
        if (emblAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.emblAccessionNumber = emblAccessionNumber;
    }

    @Override
    public boolean hasEmblAccessionNumber() {
        return !this.emblAccessionNumber.getValue().equals("");
    }

    @Override
    public EmblProteinId getEmblProteinId() {
        return this.emblProteinId;
    }

    @Override
    public void setEmblProteinId(EmblProteinId emblProteinId) {
        if (emblProteinId == null) {
            throw new IllegalArgumentException();
        }
        this.emblProteinId = emblProteinId;
    }

    @Override
    public boolean hasEmblProteinId() {
        return !this.emblProteinId.getValue().equals("");
    }

    @Override
    public EmblStatusIdentifier getEmblStatusIdentifier() {
        return this.emblStatusIdentifier;
    }

    @Override
    public void setEmblStatusIdentifier(EmblStatusIdentifier emblStatusIdentifier) {
        if (emblStatusIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.emblStatusIdentifier = emblStatusIdentifier;
    }

    @Override
    public boolean hasEmblStatusIdentifier() {
        return !this.emblStatusIdentifier.getValue().equals("");
    }

    @Override
    public EmblMoleculeType getEmblMoleculeType() {
        return this.emblMoleculeType;
    }

    @Override
    public void setEmblMoleculeType(EmblMoleculeType emblMoleculeType) {
        if (emblMoleculeType == null) {
            throw new IllegalArgumentException();
        }
        this.emblMoleculeType = emblMoleculeType;
    }

    @Override
    public boolean hasEmblMoleculeType() {
        return !this.emblMoleculeType.getValue().equals("");
    }
}

