/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.eggnog;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.eggnog.EggNOG;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.eggnog.EggNOGAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.eggnog.EggNOGDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class EggNOGImpl
extends DatabaseCrossReferenceImpl
implements EggNOG,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.EGGNOG;
    private long id = 0L;
    private EggNOGAccessionNumber eggNOGAccessionNumber = DefaultXRefFactory.getInstance().buildEggNOGAccessionNumber("");
    private EggNOGDescription eggNOGDescription = DefaultXRefFactory.getInstance().buildEggNOGDescription("");

    public EggNOGImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getEggNOGAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public EggNOGImpl(EggNOGImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasEggNOGAccessionNumber()) {
            this.setEggNOGAccessionNumber(toCopy.getEggNOGAccessionNumber());
        }
        if (toCopy.hasEggNOGDescription()) {
            this.setEggNOGDescription(toCopy.getEggNOGDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof EggNOGImpl)) {
            return false;
        }
        EggNOGImpl myClass = (EggNOGImpl)o;
        if (!this.eggNOGAccessionNumber.equals(myClass.getEggNOGAccessionNumber())) {
            return false;
        }
        return this.eggNOGDescription.equals(myClass.getEggNOGDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.eggNOGAccessionNumber != null ? this.eggNOGAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.eggNOGDescription != null ? this.eggNOGDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.eggNOGAccessionNumber + ":" + this.eggNOGDescription + ";";
    }

    @Override
    public EggNOGAccessionNumber getEggNOGAccessionNumber() {
        return this.eggNOGAccessionNumber;
    }

    @Override
    public void setEggNOGAccessionNumber(EggNOGAccessionNumber eggNOGAccessionNumber) {
        if (eggNOGAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.eggNOGAccessionNumber = eggNOGAccessionNumber;
    }

    @Override
    public boolean hasEggNOGAccessionNumber() {
        return !this.eggNOGAccessionNumber.getValue().equals("");
    }

    @Override
    public EggNOGDescription getEggNOGDescription() {
        return this.eggNOGDescription;
    }

    @Override
    public void setEggNOGDescription(EggNOGDescription eggNOGDescription) {
        if (eggNOGDescription == null) {
            throw new IllegalArgumentException();
        }
        this.eggNOGDescription = eggNOGDescription;
    }

    @Override
    public boolean hasEggNOGDescription() {
        return !this.eggNOGDescription.getValue().equals("");
    }
}

