/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.ecogene;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ecogene.EcoGene;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ecogene.EcoGeneAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ecogene.EcoGeneDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class EcoGeneImpl
extends DatabaseCrossReferenceImpl
implements EcoGene,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.ECOGENE;
    private long id = 0L;
    private EcoGeneAccessionNumber ecoGeneAccessionNumber = DefaultXRefFactory.getInstance().buildEcoGeneAccessionNumber("");
    private EcoGeneDescription ecoGeneDescription = DefaultXRefFactory.getInstance().buildEcoGeneDescription("");

    public EcoGeneImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getEcoGeneAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public EcoGeneImpl(EcoGeneImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasEcoGeneAccessionNumber()) {
            this.setEcoGeneAccessionNumber(toCopy.getEcoGeneAccessionNumber());
        }
        if (toCopy.hasEcoGeneDescription()) {
            this.setEcoGeneDescription(toCopy.getEcoGeneDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof EcoGeneImpl)) {
            return false;
        }
        EcoGeneImpl myClass = (EcoGeneImpl)o;
        if (!this.ecoGeneAccessionNumber.equals(myClass.getEcoGeneAccessionNumber())) {
            return false;
        }
        return this.ecoGeneDescription.equals(myClass.getEcoGeneDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.ecoGeneAccessionNumber != null ? this.ecoGeneAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.ecoGeneDescription != null ? this.ecoGeneDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.ecoGeneAccessionNumber + ":" + this.ecoGeneDescription + ";";
    }

    @Override
    public EcoGeneAccessionNumber getEcoGeneAccessionNumber() {
        return this.ecoGeneAccessionNumber;
    }

    @Override
    public void setEcoGeneAccessionNumber(EcoGeneAccessionNumber ecoGeneAccessionNumber) {
        if (ecoGeneAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.ecoGeneAccessionNumber = ecoGeneAccessionNumber;
    }

    @Override
    public boolean hasEcoGeneAccessionNumber() {
        return !this.ecoGeneAccessionNumber.getValue().equals("");
    }

    @Override
    public EcoGeneDescription getEcoGeneDescription() {
        return this.ecoGeneDescription;
    }

    @Override
    public void setEcoGeneDescription(EcoGeneDescription ecoGeneDescription) {
        if (ecoGeneDescription == null) {
            throw new IllegalArgumentException();
        }
        this.ecoGeneDescription = ecoGeneDescription;
    }

    @Override
    public boolean hasEcoGeneDescription() {
        return !this.ecoGeneDescription.getValue().equals("");
    }
}

