/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.eco2dbase;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.eco2dbase.Eco2dbase;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.eco2dbase.Eco2dbaseAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.eco2dbase.Eco2dbaseDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class Eco2dbaseImpl
extends DatabaseCrossReferenceImpl
implements Eco2dbase,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.ECO2DBASE;
    private long id = 0L;
    private Eco2dbaseAccessionNumber eco2dbaseAccessionNumber = DefaultXRefFactory.getInstance().buildEco2dbaseAccessionNumber("");
    private Eco2dbaseDescription eco2dbaseDescription = DefaultXRefFactory.getInstance().buildEco2dbaseDescription("");

    public Eco2dbaseImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getEco2dbaseAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public Eco2dbaseImpl(Eco2dbaseImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasEco2dbaseAccessionNumber()) {
            this.setEco2dbaseAccessionNumber(toCopy.getEco2dbaseAccessionNumber());
        }
        if (toCopy.hasEco2dbaseDescription()) {
            this.setEco2dbaseDescription(toCopy.getEco2dbaseDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Eco2dbaseImpl)) {
            return false;
        }
        Eco2dbaseImpl myClass = (Eco2dbaseImpl)o;
        if (!this.eco2dbaseAccessionNumber.equals(myClass.getEco2dbaseAccessionNumber())) {
            return false;
        }
        return this.eco2dbaseDescription.equals(myClass.getEco2dbaseDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.eco2dbaseAccessionNumber != null ? this.eco2dbaseAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.eco2dbaseDescription != null ? this.eco2dbaseDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.eco2dbaseAccessionNumber + ":" + this.eco2dbaseDescription + ";";
    }

    @Override
    public Eco2dbaseAccessionNumber getEco2dbaseAccessionNumber() {
        return this.eco2dbaseAccessionNumber;
    }

    @Override
    public void setEco2dbaseAccessionNumber(Eco2dbaseAccessionNumber eco2dbaseAccessionNumber) {
        if (eco2dbaseAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.eco2dbaseAccessionNumber = eco2dbaseAccessionNumber;
    }

    @Override
    public boolean hasEco2dbaseAccessionNumber() {
        return !this.eco2dbaseAccessionNumber.getValue().equals("");
    }

    @Override
    public Eco2dbaseDescription getEco2dbaseDescription() {
        return this.eco2dbaseDescription;
    }

    @Override
    public void setEco2dbaseDescription(Eco2dbaseDescription eco2dbaseDescription) {
        if (eco2dbaseDescription == null) {
            throw new IllegalArgumentException();
        }
        this.eco2dbaseDescription = eco2dbaseDescription;
    }

    @Override
    public boolean hasEco2dbaseDescription() {
        return !this.eco2dbaseDescription.getValue().equals("");
    }
}

