/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.echobase;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.echobase.EchoBASE;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.echobase.EchoBASEAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.echobase.EchoBASEDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class EchoBASEImpl
extends DatabaseCrossReferenceImpl
implements EchoBASE,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.ECHOBASE;
    private long id = 0L;
    private EchoBASEAccessionNumber echoBASEAccessionNumber = DefaultXRefFactory.getInstance().buildEchoBASEAccessionNumber("");
    private EchoBASEDescription echoBASEDescription = DefaultXRefFactory.getInstance().buildEchoBASEDescription("");

    public EchoBASEImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getEchoBASEAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public EchoBASEImpl(EchoBASEImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasEchoBASEAccessionNumber()) {
            this.setEchoBASEAccessionNumber(toCopy.getEchoBASEAccessionNumber());
        }
        if (toCopy.hasEchoBASEDescription()) {
            this.setEchoBASEDescription(toCopy.getEchoBASEDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof EchoBASEImpl)) {
            return false;
        }
        EchoBASEImpl myClass = (EchoBASEImpl)o;
        if (!this.echoBASEAccessionNumber.equals(myClass.getEchoBASEAccessionNumber())) {
            return false;
        }
        return this.echoBASEDescription.equals(myClass.getEchoBASEDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.echoBASEAccessionNumber != null ? this.echoBASEAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.echoBASEDescription != null ? this.echoBASEDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.echoBASEAccessionNumber + ":" + this.echoBASEDescription + ";";
    }

    @Override
    public EchoBASEAccessionNumber getEchoBASEAccessionNumber() {
        return this.echoBASEAccessionNumber;
    }

    @Override
    public void setEchoBASEAccessionNumber(EchoBASEAccessionNumber echoBASEAccessionNumber) {
        if (echoBASEAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.echoBASEAccessionNumber = echoBASEAccessionNumber;
    }

    @Override
    public boolean hasEchoBASEAccessionNumber() {
        return !this.echoBASEAccessionNumber.getValue().equals("");
    }

    @Override
    public EchoBASEDescription getEchoBASEDescription() {
        return this.echoBASEDescription;
    }

    @Override
    public void setEchoBASEDescription(EchoBASEDescription echoBASEDescription) {
        if (echoBASEDescription == null) {
            throw new IllegalArgumentException();
        }
        this.echoBASEDescription = echoBASEDescription;
    }

    @Override
    public boolean hasEchoBASEDescription() {
        return !this.echoBASEDescription.getValue().equals("");
    }
}

