/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.drugbank;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.drugbank.DrugBank;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.drugbank.DrugBankAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.drugbank.DrugBankDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class DrugBankImpl
extends DatabaseCrossReferenceImpl
implements DrugBank,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.DRUGBANK;
    private long id = 0L;
    private DrugBankAccessionNumber drugBankAccessionNumber = DefaultXRefFactory.getInstance().buildDrugBankAccessionNumber("");
    private DrugBankDescription drugBankDescription = DefaultXRefFactory.getInstance().buildDrugBankDescription("");

    public DrugBankImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getDrugBankAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public DrugBankImpl(DrugBankImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasDrugBankAccessionNumber()) {
            this.setDrugBankAccessionNumber(toCopy.getDrugBankAccessionNumber());
        }
        if (toCopy.hasDrugBankDescription()) {
            this.setDrugBankDescription(toCopy.getDrugBankDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof DrugBankImpl)) {
            return false;
        }
        DrugBankImpl myClass = (DrugBankImpl)o;
        if (!this.drugBankAccessionNumber.equals(myClass.getDrugBankAccessionNumber())) {
            return false;
        }
        return this.drugBankDescription.equals(myClass.getDrugBankDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.drugBankAccessionNumber != null ? this.drugBankAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.drugBankDescription != null ? this.drugBankDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.drugBankAccessionNumber + ":" + this.drugBankDescription + ";";
    }

    @Override
    public DrugBankAccessionNumber getDrugBankAccessionNumber() {
        return this.drugBankAccessionNumber;
    }

    @Override
    public void setDrugBankAccessionNumber(DrugBankAccessionNumber drugBankAccessionNumber) {
        if (drugBankAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.drugBankAccessionNumber = drugBankAccessionNumber;
    }

    @Override
    public boolean hasDrugBankAccessionNumber() {
        return !this.drugBankAccessionNumber.getValue().equals("");
    }

    @Override
    public DrugBankDescription getDrugBankDescription() {
        return this.drugBankDescription;
    }

    @Override
    public void setDrugBankDescription(DrugBankDescription drugBankDescription) {
        if (drugBankDescription == null) {
            throw new IllegalArgumentException();
        }
        this.drugBankDescription = drugBankDescription;
    }

    @Override
    public boolean hasDrugBankDescription() {
        return !this.drugBankDescription.getValue().equals("");
    }
}

