/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.disprot;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.disprot.DisProt;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.disprot.DisProtAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.disprot.DisProtDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class DisProtImpl
extends DatabaseCrossReferenceImpl
implements DisProt,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.DISPROT;
    private long id = 0L;
    private DisProtAccessionNumber disProtAccessionNumber = DefaultXRefFactory.getInstance().buildDisProtAccessionNumber("");
    private DisProtDescription disProtDescription = DefaultXRefFactory.getInstance().buildDisProtDescription("");

    public DisProtImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getDisProtAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public DisProtImpl(DisProtImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasDisProtAccessionNumber()) {
            this.setDisProtAccessionNumber(toCopy.getDisProtAccessionNumber());
        }
        if (toCopy.hasDisProtDescription()) {
            this.setDisProtDescription(toCopy.getDisProtDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisProtImpl)) {
            return false;
        }
        DisProtImpl myClass = (DisProtImpl)o;
        if (!this.disProtAccessionNumber.equals(myClass.getDisProtAccessionNumber())) {
            return false;
        }
        return this.disProtDescription.equals(myClass.getDisProtDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.disProtAccessionNumber != null ? this.disProtAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.disProtDescription != null ? this.disProtDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.disProtAccessionNumber + ":" + this.disProtDescription + ";";
    }

    @Override
    public DisProtAccessionNumber getDisProtAccessionNumber() {
        return this.disProtAccessionNumber;
    }

    @Override
    public void setDisProtAccessionNumber(DisProtAccessionNumber disProtAccessionNumber) {
        if (disProtAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.disProtAccessionNumber = disProtAccessionNumber;
    }

    @Override
    public boolean hasDisProtAccessionNumber() {
        return !this.disProtAccessionNumber.getValue().equals("");
    }

    @Override
    public DisProtDescription getDisProtDescription() {
        return this.disProtDescription;
    }

    @Override
    public void setDisProtDescription(DisProtDescription disProtDescription) {
        if (disProtDescription == null) {
            throw new IllegalArgumentException();
        }
        this.disProtDescription = disProtDescription;
    }

    @Override
    public boolean hasDisProtDescription() {
        return !this.disProtDescription.getValue().equals("");
    }
}

