/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.dip;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.dip.DIP;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.dip.DIPAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.dip.DIPDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class DIPImpl
extends DatabaseCrossReferenceImpl
implements DIP,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.DIP;
    private long id = 0L;
    private DIPAccessionNumber dIPAccessionNumber = DefaultXRefFactory.getInstance().buildDIPAccessionNumber("");
    private DIPDescription dIPDescription = DefaultXRefFactory.getInstance().buildDIPDescription("");

    public DIPImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getDIPAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public DIPImpl(DIPImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasDIPAccessionNumber()) {
            this.setDIPAccessionNumber(toCopy.getDIPAccessionNumber());
        }
        if (toCopy.hasDIPDescription()) {
            this.setDIPDescription(toCopy.getDIPDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof DIPImpl)) {
            return false;
        }
        DIPImpl myClass = (DIPImpl)o;
        if (!this.dIPAccessionNumber.equals(myClass.getDIPAccessionNumber())) {
            return false;
        }
        return this.dIPDescription.equals(myClass.getDIPDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.dIPAccessionNumber != null ? this.dIPAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.dIPDescription != null ? this.dIPDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.dIPAccessionNumber + ":" + this.dIPDescription + ";";
    }

    @Override
    public DIPAccessionNumber getDIPAccessionNumber() {
        return this.dIPAccessionNumber;
    }

    @Override
    public void setDIPAccessionNumber(DIPAccessionNumber dIPAccessionNumber) {
        if (dIPAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.dIPAccessionNumber = dIPAccessionNumber;
    }

    @Override
    public boolean hasDIPAccessionNumber() {
        return !this.dIPAccessionNumber.getValue().equals("");
    }

    @Override
    public DIPDescription getDIPDescription() {
        return this.dIPDescription;
    }

    @Override
    public void setDIPDescription(DIPDescription dIPDescription) {
        if (dIPDescription == null) {
            throw new IllegalArgumentException();
        }
        this.dIPDescription = dIPDescription;
    }

    @Override
    public boolean hasDIPDescription() {
        return !this.dIPDescription.getValue().equals("");
    }
}

