/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.dictybase;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.dictybase.DictyBase;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.dictybase.DictyBaseAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.dictybase.DictyBaseDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class DictyBaseImpl
extends DatabaseCrossReferenceImpl
implements DictyBase,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.DICTYBASE;
    private long id = 0L;
    private DictyBaseAccessionNumber dictyBaseAccessionNumber = DefaultXRefFactory.getInstance().buildDictyBaseAccessionNumber("");
    private DictyBaseDescription dictyBaseDescription = DefaultXRefFactory.getInstance().buildDictyBaseDescription("");

    public DictyBaseImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getDictyBaseAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public DictyBaseImpl(DictyBaseImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasDictyBaseAccessionNumber()) {
            this.setDictyBaseAccessionNumber(toCopy.getDictyBaseAccessionNumber());
        }
        if (toCopy.hasDictyBaseDescription()) {
            this.setDictyBaseDescription(toCopy.getDictyBaseDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof DictyBaseImpl)) {
            return false;
        }
        DictyBaseImpl myClass = (DictyBaseImpl)o;
        if (!this.dictyBaseAccessionNumber.equals(myClass.getDictyBaseAccessionNumber())) {
            return false;
        }
        return this.dictyBaseDescription.equals(myClass.getDictyBaseDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.dictyBaseAccessionNumber != null ? this.dictyBaseAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.dictyBaseDescription != null ? this.dictyBaseDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.dictyBaseAccessionNumber + ":" + this.dictyBaseDescription + ";";
    }

    @Override
    public DictyBaseAccessionNumber getDictyBaseAccessionNumber() {
        return this.dictyBaseAccessionNumber;
    }

    @Override
    public void setDictyBaseAccessionNumber(DictyBaseAccessionNumber dictyBaseAccessionNumber) {
        if (dictyBaseAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.dictyBaseAccessionNumber = dictyBaseAccessionNumber;
    }

    @Override
    public boolean hasDictyBaseAccessionNumber() {
        return !this.dictyBaseAccessionNumber.getValue().equals("");
    }

    @Override
    public DictyBaseDescription getDictyBaseDescription() {
        return this.dictyBaseDescription;
    }

    @Override
    public void setDictyBaseDescription(DictyBaseDescription dictyBaseDescription) {
        if (dictyBaseDescription == null) {
            throw new IllegalArgumentException();
        }
        this.dictyBaseDescription = dictyBaseDescription;
    }

    @Override
    public boolean hasDictyBaseDescription() {
        return !this.dictyBaseDescription.getValue().equals("");
    }
}

