/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.cygd;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cygd.Cygd;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cygd.CygdAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cygd.CygdDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class CygdImpl
extends DatabaseCrossReferenceImpl
implements Cygd,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.CYGD;
    private long id = 0L;
    private CygdAccessionNumber cygdAccessionNumber = DefaultXRefFactory.getInstance().buildCygdAccessionNumber("");
    private CygdDescription cygdDescription = DefaultXRefFactory.getInstance().buildCygdDescription("");

    public CygdImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getCygdAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public CygdImpl(CygdImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasCygdAccessionNumber()) {
            this.setCygdAccessionNumber(toCopy.getCygdAccessionNumber());
        }
        if (toCopy.hasCygdDescription()) {
            this.setCygdDescription(toCopy.getCygdDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof CygdImpl)) {
            return false;
        }
        CygdImpl myClass = (CygdImpl)o;
        if (!this.cygdAccessionNumber.equals(myClass.getCygdAccessionNumber())) {
            return false;
        }
        return this.cygdDescription.equals(myClass.getCygdDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.cygdAccessionNumber != null ? this.cygdAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.cygdDescription != null ? this.cygdDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.cygdAccessionNumber + ":" + this.cygdDescription + ";";
    }

    @Override
    public CygdAccessionNumber getCygdAccessionNumber() {
        return this.cygdAccessionNumber;
    }

    @Override
    public void setCygdAccessionNumber(CygdAccessionNumber cygdAccessionNumber) {
        if (cygdAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.cygdAccessionNumber = cygdAccessionNumber;
    }

    @Override
    public boolean hasCygdAccessionNumber() {
        return !this.cygdAccessionNumber.getValue().equals("");
    }

    @Override
    public CygdDescription getCygdDescription() {
        return this.cygdDescription;
    }

    @Override
    public void setCygdDescription(CygdDescription cygdDescription) {
        if (cygdDescription == null) {
            throw new IllegalArgumentException();
        }
        this.cygdDescription = cygdDescription;
    }

    @Override
    public boolean hasCygdDescription() {
        return !this.cygdDescription.getValue().equals("");
    }
}

