/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.ctd;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ctd.Ctd;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ctd.CtdDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.ctd.CtdGeneId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class CtdImpl
extends DatabaseCrossReferenceImpl
implements Ctd,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.CTD;
    private long id = 0L;
    private CtdGeneId ctdGeneId = DefaultXRefFactory.getInstance().buildCtdGeneId("");
    private CtdDescription ctdDescription = DefaultXRefFactory.getInstance().buildCtdDescription("");

    public CtdImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getCtdGeneId().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public CtdImpl(CtdImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasCtdGeneId()) {
            this.setCtdGeneId(toCopy.getCtdGeneId());
        }
        if (toCopy.hasCtdDescription()) {
            this.setCtdDescription(toCopy.getCtdDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof CtdImpl)) {
            return false;
        }
        CtdImpl myClass = (CtdImpl)o;
        if (!this.ctdGeneId.equals(myClass.getCtdGeneId())) {
            return false;
        }
        return this.ctdDescription.equals(myClass.getCtdDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.ctdGeneId != null ? this.ctdGeneId.hashCode() : 0);
        result = 29 * result + (this.ctdDescription != null ? this.ctdDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.ctdGeneId + ":" + this.ctdDescription + ";";
    }

    @Override
    public CtdGeneId getCtdGeneId() {
        return this.ctdGeneId;
    }

    @Override
    public void setCtdGeneId(CtdGeneId ctdGeneId) {
        if (ctdGeneId == null) {
            throw new IllegalArgumentException();
        }
        this.ctdGeneId = ctdGeneId;
    }

    @Override
    public boolean hasCtdGeneId() {
        return !this.ctdGeneId.getValue().equals("");
    }

    @Override
    public CtdDescription getCtdDescription() {
        return this.ctdDescription;
    }

    @Override
    public void setCtdDescription(CtdDescription ctdDescription) {
        if (ctdDescription == null) {
            throw new IllegalArgumentException();
        }
        this.ctdDescription = ctdDescription;
    }

    @Override
    public boolean hasCtdDescription() {
        return !this.ctdDescription.getValue().equals("");
    }
}

