/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.conoserver;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.conoserver.ConoServer;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.conoserver.ConoServerIdentifier;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.conoserver.ConoServerToxinName;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class ConoServerImpl
extends DatabaseCrossReferenceImpl
implements ConoServer,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.CONOSERVER;
    private long id = 0L;
    private ConoServerIdentifier conoServerIdentifier = DefaultXRefFactory.getInstance().buildConoServerIdentifier("");
    private ConoServerToxinName conoServerToxinName = DefaultXRefFactory.getInstance().buildConoServerToxinName("");

    public ConoServerImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getConoServerIdentifier().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public ConoServerImpl(ConoServerImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasConoServerIdentifier()) {
            this.setConoServerIdentifier(toCopy.getConoServerIdentifier());
        }
        if (toCopy.hasConoServerToxinName()) {
            this.setConoServerToxinName(toCopy.getConoServerToxinName());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConoServerImpl)) {
            return false;
        }
        ConoServerImpl myClass = (ConoServerImpl)o;
        if (!this.conoServerIdentifier.equals(myClass.getConoServerIdentifier())) {
            return false;
        }
        return this.conoServerToxinName.equals(myClass.getConoServerToxinName());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.conoServerIdentifier != null ? this.conoServerIdentifier.hashCode() : 0);
        result = 29 * result + (this.conoServerToxinName != null ? this.conoServerToxinName.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.conoServerIdentifier + ":" + this.conoServerToxinName + ";";
    }

    @Override
    public ConoServerIdentifier getConoServerIdentifier() {
        return this.conoServerIdentifier;
    }

    @Override
    public void setConoServerIdentifier(ConoServerIdentifier conoServerIdentifier) {
        if (conoServerIdentifier == null) {
            throw new IllegalArgumentException();
        }
        this.conoServerIdentifier = conoServerIdentifier;
    }

    @Override
    public boolean hasConoServerIdentifier() {
        return !this.conoServerIdentifier.getValue().equals("");
    }

    @Override
    public ConoServerToxinName getConoServerToxinName() {
        return this.conoServerToxinName;
    }

    @Override
    public void setConoServerToxinName(ConoServerToxinName conoServerToxinName) {
        if (conoServerToxinName == null) {
            throw new IllegalArgumentException();
        }
        this.conoServerToxinName = conoServerToxinName;
    }

    @Override
    public boolean hasConoServerToxinName() {
        return !this.conoServerToxinName.getValue().equals("");
    }
}

