/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.cleanex;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cleanex.CleanEx;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cleanex.CleanExAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cleanex.CleanExDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class CleanExImpl
extends DatabaseCrossReferenceImpl
implements CleanEx,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.CLEANEX;
    private long id = 0L;
    private CleanExAccessionNumber cleanExAccessionNumber = DefaultXRefFactory.getInstance().buildCleanExAccessionNumber("");
    private CleanExDescription cleanExDescription = DefaultXRefFactory.getInstance().buildCleanExDescription("");

    public CleanExImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getCleanExAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public CleanExImpl(CleanExImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasCleanExAccessionNumber()) {
            this.setCleanExAccessionNumber(toCopy.getCleanExAccessionNumber());
        }
        if (toCopy.hasCleanExDescription()) {
            this.setCleanExDescription(toCopy.getCleanExDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof CleanExImpl)) {
            return false;
        }
        CleanExImpl myClass = (CleanExImpl)o;
        if (!this.cleanExAccessionNumber.equals(myClass.getCleanExAccessionNumber())) {
            return false;
        }
        return this.cleanExDescription.equals(myClass.getCleanExDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.cleanExAccessionNumber != null ? this.cleanExAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.cleanExDescription != null ? this.cleanExDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.cleanExAccessionNumber + ":" + this.cleanExDescription + ";";
    }

    @Override
    public CleanExAccessionNumber getCleanExAccessionNumber() {
        return this.cleanExAccessionNumber;
    }

    @Override
    public void setCleanExAccessionNumber(CleanExAccessionNumber cleanExAccessionNumber) {
        if (cleanExAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.cleanExAccessionNumber = cleanExAccessionNumber;
    }

    @Override
    public boolean hasCleanExAccessionNumber() {
        return !this.cleanExAccessionNumber.getValue().equals("");
    }

    @Override
    public CleanExDescription getCleanExDescription() {
        return this.cleanExDescription;
    }

    @Override
    public void setCleanExDescription(CleanExDescription cleanExDescription) {
        if (cleanExDescription == null) {
            throw new IllegalArgumentException();
        }
        this.cleanExDescription = cleanExDescription;
    }

    @Override
    public boolean hasCleanExDescription() {
        return !this.cleanExDescription.getValue().equals("");
    }
}

