/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.cgd;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cgd.Cgd;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cgd.CgdAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cgd.CgdGeneName;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class CgdImpl
extends DatabaseCrossReferenceImpl
implements Cgd,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.CGD;
    private long id = 0L;
    private CgdAccessionNumber cgdAccessionNumber = DefaultXRefFactory.getInstance().buildCgdAccessionNumber("");
    private CgdGeneName cgdGeneName = DefaultXRefFactory.getInstance().buildCgdGeneName("");

    public CgdImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getCgdAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public CgdImpl(CgdImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasCgdAccessionNumber()) {
            this.setCgdAccessionNumber(toCopy.getCgdAccessionNumber());
        }
        if (toCopy.hasCgdGeneName()) {
            this.setCgdGeneName(toCopy.getCgdGeneName());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof CgdImpl)) {
            return false;
        }
        CgdImpl myClass = (CgdImpl)o;
        if (!this.cgdAccessionNumber.equals(myClass.getCgdAccessionNumber())) {
            return false;
        }
        return this.cgdGeneName.equals(myClass.getCgdGeneName());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.cgdAccessionNumber != null ? this.cgdAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.cgdGeneName != null ? this.cgdGeneName.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.cgdAccessionNumber + ":" + this.cgdGeneName + ";";
    }

    @Override
    public CgdAccessionNumber getCgdAccessionNumber() {
        return this.cgdAccessionNumber;
    }

    @Override
    public void setCgdAccessionNumber(CgdAccessionNumber cgdAccessionNumber) {
        if (cgdAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.cgdAccessionNumber = cgdAccessionNumber;
    }

    @Override
    public boolean hasCgdAccessionNumber() {
        return !this.cgdAccessionNumber.getValue().equals("");
    }

    @Override
    public CgdGeneName getCgdGeneName() {
        return this.cgdGeneName;
    }

    @Override
    public void setCgdGeneName(CgdGeneName cgdGeneName) {
        if (cgdGeneName == null) {
            throw new IllegalArgumentException();
        }
        this.cgdGeneName = cgdGeneName;
    }

    @Override
    public boolean hasCgdGeneName() {
        return !this.cgdGeneName.getValue().equals("");
    }
}

