/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.cazy;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cazy.Cazy;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cazy.CazyFamilyName;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.cazy.CazyFamilyNumber;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class CazyImpl
extends DatabaseCrossReferenceImpl
implements Cazy,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.CAZY;
    private long id = 0L;
    private CazyFamilyNumber cazyFamilyNumber = DefaultXRefFactory.getInstance().buildCazyFamilyNumber("");
    private CazyFamilyName cazyFamilyName = DefaultXRefFactory.getInstance().buildCazyFamilyName("");

    public CazyImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getCazyFamilyNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public CazyImpl(CazyImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasCazyFamilyNumber()) {
            this.setCazyFamilyNumber(toCopy.getCazyFamilyNumber());
        }
        if (toCopy.hasCazyFamilyName()) {
            this.setCazyFamilyName(toCopy.getCazyFamilyName());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof CazyImpl)) {
            return false;
        }
        CazyImpl myClass = (CazyImpl)o;
        if (!this.cazyFamilyNumber.equals(myClass.getCazyFamilyNumber())) {
            return false;
        }
        return this.cazyFamilyName.equals(myClass.getCazyFamilyName());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.cazyFamilyNumber != null ? this.cazyFamilyNumber.hashCode() : 0);
        result = 29 * result + (this.cazyFamilyName != null ? this.cazyFamilyName.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.cazyFamilyNumber + ":" + this.cazyFamilyName + ";";
    }

    @Override
    public CazyFamilyNumber getCazyFamilyNumber() {
        return this.cazyFamilyNumber;
    }

    @Override
    public void setCazyFamilyNumber(CazyFamilyNumber cazyFamilyNumber) {
        if (cazyFamilyNumber == null) {
            throw new IllegalArgumentException();
        }
        this.cazyFamilyNumber = cazyFamilyNumber;
    }

    @Override
    public boolean hasCazyFamilyNumber() {
        return !this.cazyFamilyNumber.getValue().equals("");
    }

    @Override
    public CazyFamilyName getCazyFamilyName() {
        return this.cazyFamilyName;
    }

    @Override
    public void setCazyFamilyName(CazyFamilyName cazyFamilyName) {
        if (cazyFamilyName == null) {
            throw new IllegalArgumentException();
        }
        this.cazyFamilyName = cazyFamilyName;
    }

    @Override
    public boolean hasCazyFamilyName() {
        return !this.cazyFamilyName.getValue().equals("");
    }
}

