/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.carbbank;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.carbbank.CarbBank;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.carbbank.CarbBankAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.carbbank.CarbBankDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class CarbBankImpl
extends DatabaseCrossReferenceImpl
implements CarbBank,
PersistentObject {
    private DatabaseType databaseType = DatabaseType.CARBBANK;
    private long id = 0L;
    private CarbBankAccessionNumber carbBankAccessionNumber = DefaultXRefFactory.getInstance().buildCarbBankAccessionNumber("");
    private CarbBankDescription carbBankDescription = DefaultXRefFactory.getInstance().buildCarbBankDescription("");

    public CarbBankImpl() {
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public CarbBankImpl(CarbBankImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasCarbBankAccessionNumber()) {
            this.setCarbBankAccessionNumber(toCopy.getCarbBankAccessionNumber());
        }
        if (toCopy.hasCarbBankDescription()) {
            this.setCarbBankDescription(toCopy.getCarbBankDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof CarbBankImpl)) {
            return false;
        }
        CarbBankImpl myClass = (CarbBankImpl)o;
        if (!this.carbBankAccessionNumber.equals(myClass.getCarbBankAccessionNumber())) {
            return false;
        }
        return this.carbBankDescription.equals(myClass.getCarbBankDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.carbBankAccessionNumber != null ? this.carbBankAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.carbBankDescription != null ? this.carbBankDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.carbBankAccessionNumber + ":" + this.carbBankDescription + ";";
    }

    @Override
    public CarbBankAccessionNumber getCarbBankAccessionNumber() {
        return this.carbBankAccessionNumber;
    }

    @Override
    public void setCarbBankAccessionNumber(CarbBankAccessionNumber carbBankAccessionNumber) {
        if (carbBankAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.carbBankAccessionNumber = carbBankAccessionNumber;
    }

    @Override
    public boolean hasCarbBankAccessionNumber() {
        return !this.carbBankAccessionNumber.getValue().equals("");
    }

    @Override
    public CarbBankDescription getCarbBankDescription() {
        return this.carbBankDescription;
    }

    @Override
    public void setCarbBankDescription(CarbBankDescription carbBankDescription) {
        if (carbBankDescription == null) {
            throw new IllegalArgumentException();
        }
        this.carbBankDescription = carbBankDescription;
    }

    @Override
    public boolean hasCarbBankDescription() {
        return !this.carbBankDescription.getValue().equals("");
    }
}

