/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.burulist;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.burulist.BuruList;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.burulist.BuruListAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.burulist.BuruListDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class BuruListImpl
extends DatabaseCrossReferenceImpl
implements BuruList,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.BURULIST;
    private long id = 0L;
    private BuruListAccessionNumber buruListAccessionNumber = DefaultXRefFactory.getInstance().buildBuruListAccessionNumber("");
    private BuruListDescription buruListDescription = DefaultXRefFactory.getInstance().buildBuruListDescription("");

    public BuruListImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getBuruListAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public BuruListImpl(BuruListImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasBuruListAccessionNumber()) {
            this.setBuruListAccessionNumber(toCopy.getBuruListAccessionNumber());
        }
        if (toCopy.hasBuruListDescription()) {
            this.setBuruListDescription(toCopy.getBuruListDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuruListImpl)) {
            return false;
        }
        BuruListImpl myClass = (BuruListImpl)o;
        if (!this.buruListAccessionNumber.equals(myClass.getBuruListAccessionNumber())) {
            return false;
        }
        return this.buruListDescription.equals(myClass.getBuruListDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.buruListAccessionNumber != null ? this.buruListAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.buruListDescription != null ? this.buruListDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.buruListAccessionNumber + ":" + this.buruListDescription + ";";
    }

    @Override
    public BuruListAccessionNumber getBuruListAccessionNumber() {
        return this.buruListAccessionNumber;
    }

    @Override
    public void setBuruListAccessionNumber(BuruListAccessionNumber buruListAccessionNumber) {
        if (buruListAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.buruListAccessionNumber = buruListAccessionNumber;
    }

    @Override
    public boolean hasBuruListAccessionNumber() {
        return !this.buruListAccessionNumber.getValue().equals("");
    }

    @Override
    public BuruListDescription getBuruListDescription() {
        return this.buruListDescription;
    }

    @Override
    public void setBuruListDescription(BuruListDescription buruListDescription) {
        if (buruListDescription == null) {
            throw new IllegalArgumentException();
        }
        this.buruListDescription = buruListDescription;
    }

    @Override
    public boolean hasBuruListDescription() {
        return !this.buruListDescription.getValue().equals("");
    }
}

