/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.brenda;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.brenda.Brenda;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.brenda.BrendaEcNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.brenda.BrendaOrganismCode;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class BrendaImpl
extends DatabaseCrossReferenceImpl
implements Brenda,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.BRENDA;
    private long id = 0L;
    private BrendaEcNumber brendaEcNumber = DefaultXRefFactory.getInstance().buildBrendaEcNumber("");
    private BrendaOrganismCode brendaOrganismCode = DefaultXRefFactory.getInstance().buildBrendaOrganismCode("");

    public BrendaImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getBrendaEcNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public BrendaImpl(BrendaImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasBrendaEcNumber()) {
            this.setBrendaEcNumber(toCopy.getBrendaEcNumber());
        }
        if (toCopy.hasBrendaOrganismCode()) {
            this.setBrendaOrganismCode(toCopy.getBrendaOrganismCode());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrendaImpl)) {
            return false;
        }
        BrendaImpl myClass = (BrendaImpl)o;
        if (!this.brendaEcNumber.equals(myClass.getBrendaEcNumber())) {
            return false;
        }
        return this.brendaOrganismCode.equals(myClass.getBrendaOrganismCode());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.brendaEcNumber != null ? this.brendaEcNumber.hashCode() : 0);
        result = 29 * result + (this.brendaOrganismCode != null ? this.brendaOrganismCode.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.brendaEcNumber + ":" + this.brendaOrganismCode + ";";
    }

    @Override
    public BrendaEcNumber getBrendaEcNumber() {
        return this.brendaEcNumber;
    }

    @Override
    public void setBrendaEcNumber(BrendaEcNumber brendaEcNumber) {
        if (brendaEcNumber == null) {
            throw new IllegalArgumentException();
        }
        this.brendaEcNumber = brendaEcNumber;
    }

    @Override
    public boolean hasBrendaEcNumber() {
        return !this.brendaEcNumber.getValue().equals("");
    }

    @Override
    public BrendaOrganismCode getBrendaOrganismCode() {
        return this.brendaOrganismCode;
    }

    @Override
    public void setBrendaOrganismCode(BrendaOrganismCode brendaOrganismCode) {
        if (brendaOrganismCode == null) {
            throw new IllegalArgumentException();
        }
        this.brendaOrganismCode = brendaOrganismCode;
    }

    @Override
    public boolean hasBrendaOrganismCode() {
        return !this.brendaOrganismCode.getValue().equals("");
    }
}

