/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.biocyc;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.biocyc.BioCyc;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.biocyc.BioCycAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.biocyc.BioCycDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class BioCycImpl
extends DatabaseCrossReferenceImpl
implements BioCyc,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.BIOCYC;
    private long id = 0L;
    private BioCycAccessionNumber bioCycAccessionNumber = DefaultXRefFactory.getInstance().buildBioCycAccessionNumber("");
    private BioCycDescription bioCycDescription = DefaultXRefFactory.getInstance().buildBioCycDescription("");

    public BioCycImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getBioCycAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public BioCycImpl(BioCycImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasBioCycAccessionNumber()) {
            this.setBioCycAccessionNumber(toCopy.getBioCycAccessionNumber());
        }
        if (toCopy.hasBioCycDescription()) {
            this.setBioCycDescription(toCopy.getBioCycDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof BioCycImpl)) {
            return false;
        }
        BioCycImpl myClass = (BioCycImpl)o;
        if (!this.bioCycAccessionNumber.equals(myClass.getBioCycAccessionNumber())) {
            return false;
        }
        return this.bioCycDescription.equals(myClass.getBioCycDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.bioCycAccessionNumber != null ? this.bioCycAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.bioCycDescription != null ? this.bioCycDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.bioCycAccessionNumber + ":" + this.bioCycDescription + ";";
    }

    @Override
    public BioCycAccessionNumber getBioCycAccessionNumber() {
        return this.bioCycAccessionNumber;
    }

    @Override
    public void setBioCycAccessionNumber(BioCycAccessionNumber bioCycAccessionNumber) {
        if (bioCycAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.bioCycAccessionNumber = bioCycAccessionNumber;
    }

    @Override
    public boolean hasBioCycAccessionNumber() {
        return !this.bioCycAccessionNumber.getValue().equals("");
    }

    @Override
    public BioCycDescription getBioCycDescription() {
        return this.bioCycDescription;
    }

    @Override
    public void setBioCycDescription(BioCycDescription bioCycDescription) {
        if (bioCycDescription == null) {
            throw new IllegalArgumentException();
        }
        this.bioCycDescription = bioCycDescription;
    }

    @Override
    public boolean hasBioCycDescription() {
        return !this.bioCycDescription.getValue().equals("");
    }
}

