/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.bindingdb;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.bindingdb.BindingDB;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.bindingdb.BindingDBAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.bindingdb.BindingDBDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class BindingDBImpl
extends DatabaseCrossReferenceImpl
implements BindingDB,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.BINDINGDB;
    private long id = 0L;
    private BindingDBAccessionNumber bindingDBAccessionNumber = DefaultXRefFactory.getInstance().buildBindingDBAccessionNumber("");
    private BindingDBDescription bindingDBDescription = DefaultXRefFactory.getInstance().buildBindingDBDescription("");

    public BindingDBImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getBindingDBAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public BindingDBImpl(BindingDBImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasBindingDBAccessionNumber()) {
            this.setBindingDBAccessionNumber(toCopy.getBindingDBAccessionNumber());
        }
        if (toCopy.hasBindingDBDescription()) {
            this.setBindingDBDescription(toCopy.getBindingDBDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof BindingDBImpl)) {
            return false;
        }
        BindingDBImpl myClass = (BindingDBImpl)o;
        if (!this.bindingDBAccessionNumber.equals(myClass.getBindingDBAccessionNumber())) {
            return false;
        }
        return this.bindingDBDescription.equals(myClass.getBindingDBDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.bindingDBAccessionNumber != null ? this.bindingDBAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.bindingDBDescription != null ? this.bindingDBDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.bindingDBAccessionNumber + ":" + this.bindingDBDescription + ";";
    }

    @Override
    public BindingDBAccessionNumber getBindingDBAccessionNumber() {
        return this.bindingDBAccessionNumber;
    }

    @Override
    public void setBindingDBAccessionNumber(BindingDBAccessionNumber bindingDBAccessionNumber) {
        if (bindingDBAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.bindingDBAccessionNumber = bindingDBAccessionNumber;
    }

    @Override
    public boolean hasBindingDBAccessionNumber() {
        return !this.bindingDBAccessionNumber.getValue().equals("");
    }

    @Override
    public BindingDBDescription getBindingDBDescription() {
        return this.bindingDBDescription;
    }

    @Override
    public void setBindingDBDescription(BindingDBDescription bindingDBDescription) {
        if (bindingDBDescription == null) {
            throw new IllegalArgumentException();
        }
        this.bindingDBDescription = bindingDBDescription;
    }

    @Override
    public boolean hasBindingDBDescription() {
        return !this.bindingDBDescription.getValue().equals("");
    }
}

