/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.bgee;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.bgee.Bgee;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.bgee.BgeeAcNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.bgee.BgeeDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class BgeeImpl
extends DatabaseCrossReferenceImpl
implements Bgee,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.BGEE;
    private long id = 0L;
    private BgeeAcNumber bgeeAcNumber = DefaultXRefFactory.getInstance().buildBgeeAcNumber("");
    private BgeeDescription bgeeDescription = DefaultXRefFactory.getInstance().buildBgeeDescription("");

    public BgeeImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getBgeeAcNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public BgeeImpl(BgeeImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasBgeeAcNumber()) {
            this.setBgeeAcNumber(toCopy.getBgeeAcNumber());
        }
        if (toCopy.hasBgeeDescription()) {
            this.setBgeeDescription(toCopy.getBgeeDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof BgeeImpl)) {
            return false;
        }
        BgeeImpl myClass = (BgeeImpl)o;
        if (!this.bgeeAcNumber.equals(myClass.getBgeeAcNumber())) {
            return false;
        }
        return this.bgeeDescription.equals(myClass.getBgeeDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.bgeeAcNumber != null ? this.bgeeAcNumber.hashCode() : 0);
        result = 29 * result + (this.bgeeDescription != null ? this.bgeeDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.bgeeAcNumber + ":" + this.bgeeDescription + ";";
    }

    @Override
    public BgeeAcNumber getBgeeAcNumber() {
        return this.bgeeAcNumber;
    }

    @Override
    public void setBgeeAcNumber(BgeeAcNumber bgeeAcNumber) {
        if (bgeeAcNumber == null) {
            throw new IllegalArgumentException();
        }
        this.bgeeAcNumber = bgeeAcNumber;
    }

    @Override
    public boolean hasBgeeAcNumber() {
        return !this.bgeeAcNumber.getValue().equals("");
    }

    @Override
    public BgeeDescription getBgeeDescription() {
        return this.bgeeDescription;
    }

    @Override
    public void setBgeeDescription(BgeeDescription bgeeDescription) {
        if (bgeeDescription == null) {
            throw new IllegalArgumentException();
        }
        this.bgeeDescription = bgeeDescription;
    }

    @Override
    public boolean hasBgeeDescription() {
        return !this.bgeeDescription.getValue().equals("");
    }
}

