/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.arrayexpress;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.arrayexpress.ArrayExpress;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.arrayexpress.ArrayExpressAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.arrayexpress.ArrayExpressDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class ArrayExpressImpl
extends DatabaseCrossReferenceImpl
implements ArrayExpress,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.ARRAYEXPRESS;
    private long id = 0L;
    private ArrayExpressAccessionNumber arrayExpressAccessionNumber = DefaultXRefFactory.getInstance().buildArrayExpressAccessionNumber("");
    private ArrayExpressDescription arrayExpressDescription = DefaultXRefFactory.getInstance().buildArrayExpressDescription("");

    public ArrayExpressImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getArrayExpressAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public ArrayExpressImpl(ArrayExpressImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasArrayExpressAccessionNumber()) {
            this.setArrayExpressAccessionNumber(toCopy.getArrayExpressAccessionNumber());
        }
        if (toCopy.hasArrayExpressDescription()) {
            this.setArrayExpressDescription(toCopy.getArrayExpressDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayExpressImpl)) {
            return false;
        }
        ArrayExpressImpl myClass = (ArrayExpressImpl)o;
        if (!this.arrayExpressAccessionNumber.equals(myClass.getArrayExpressAccessionNumber())) {
            return false;
        }
        return this.arrayExpressDescription.equals(myClass.getArrayExpressDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.arrayExpressAccessionNumber != null ? this.arrayExpressAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.arrayExpressDescription != null ? this.arrayExpressDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.arrayExpressAccessionNumber + ":" + this.arrayExpressDescription + ";";
    }

    @Override
    public ArrayExpressAccessionNumber getArrayExpressAccessionNumber() {
        return this.arrayExpressAccessionNumber;
    }

    @Override
    public void setArrayExpressAccessionNumber(ArrayExpressAccessionNumber arrayExpressAccessionNumber) {
        if (arrayExpressAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.arrayExpressAccessionNumber = arrayExpressAccessionNumber;
    }

    @Override
    public boolean hasArrayExpressAccessionNumber() {
        return !this.arrayExpressAccessionNumber.getValue().equals("");
    }

    @Override
    public ArrayExpressDescription getArrayExpressDescription() {
        return this.arrayExpressDescription;
    }

    @Override
    public void setArrayExpressDescription(ArrayExpressDescription arrayExpressDescription) {
        if (arrayExpressDescription == null) {
            throw new IllegalArgumentException();
        }
        this.arrayExpressDescription = arrayExpressDescription;
    }

    @Override
    public boolean hasArrayExpressDescription() {
        return !this.arrayExpressDescription.getValue().equals("");
    }
}

