/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.arachnoserver;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.arachnoserver.ArachnoServer;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.arachnoserver.ArachnoServerAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.arachnoserver.ArachnoServerDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class ArachnoServerImpl
extends DatabaseCrossReferenceImpl
implements ArachnoServer,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.ARACHNOSERVER;
    private long id = 0L;
    private ArachnoServerAccessionNumber arachnoServerAccessionNumber = DefaultXRefFactory.getInstance().buildArachnoServerAccessionNumber("");
    private ArachnoServerDescription arachnoServerDescription = DefaultXRefFactory.getInstance().buildArachnoServerDescription("");

    public ArachnoServerImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getArachnoServerAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public ArachnoServerImpl(ArachnoServerImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasArachnoServerAccessionNumber()) {
            this.setArachnoServerAccessionNumber(toCopy.getArachnoServerAccessionNumber());
        }
        if (toCopy.hasArachnoServerDescription()) {
            this.setArachnoServerDescription(toCopy.getArachnoServerDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArachnoServerImpl)) {
            return false;
        }
        ArachnoServerImpl myClass = (ArachnoServerImpl)o;
        if (!this.arachnoServerAccessionNumber.equals(myClass.getArachnoServerAccessionNumber())) {
            return false;
        }
        return this.arachnoServerDescription.equals(myClass.getArachnoServerDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.arachnoServerAccessionNumber != null ? this.arachnoServerAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.arachnoServerDescription != null ? this.arachnoServerDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.arachnoServerAccessionNumber + ":" + this.arachnoServerDescription + ";";
    }

    @Override
    public ArachnoServerAccessionNumber getArachnoServerAccessionNumber() {
        return this.arachnoServerAccessionNumber;
    }

    @Override
    public void setArachnoServerAccessionNumber(ArachnoServerAccessionNumber arachnoServerAccessionNumber) {
        if (arachnoServerAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.arachnoServerAccessionNumber = arachnoServerAccessionNumber;
    }

    @Override
    public boolean hasArachnoServerAccessionNumber() {
        return !this.arachnoServerAccessionNumber.getValue().equals("");
    }

    @Override
    public ArachnoServerDescription getArachnoServerDescription() {
        return this.arachnoServerDescription;
    }

    @Override
    public void setArachnoServerDescription(ArachnoServerDescription arachnoServerDescription) {
        if (arachnoServerDescription == null) {
            throw new IllegalArgumentException();
        }
        this.arachnoServerDescription = arachnoServerDescription;
    }

    @Override
    public boolean hasArachnoServerDescription() {
        return !this.arachnoServerDescription.getValue().equals("");
    }
}

